<header class="bg-white border-b border-gray-200 h-16">
    <div class="flex items-center justify-between h-full px-4 sm:px-6 lg:px-8">
        <div class="flex items-center flex-1">
            <button type="button" class="lg:hidden text-gray-500 hover:text-gray-700">
                <span class="material-symbols-outlined">menu</span>
            </button>
            
            <div class="ml-4 flex-1 max-w-md">
                <input type="search" placeholder="Search..." 
                       class="w-full px-4 py-2 border border-gray-300 rounded-lg bg-gray-50 text-gray-900 focus:ring-2 focus:ring-blue-500">
            </div>
        </div>
        
        <div class="flex items-center space-x-4">
            <button class="relative text-gray-500 hover:text-gray-700">
                <span class="material-symbols-outlined">notifications</span>
                <span class="absolute top-0 right-0 block h-2 w-2 rounded-full bg-red-500"></span>
            </button>
            
            <div x-data="{ open: false }" class="relative">
                <button @click="open = !open" class="flex items-center space-x-2 text-gray-700 hover:bg-gray-100 px-2 py-1 rounded-lg transition-colors cursor-pointer">
                    <img src="{{ auth()->user()->avatar ?? 'https://ui-avatars.com/api/?name=' . urlencode(auth()->user()->name) }}" 
                         alt="{{ auth()->user()->name }}" 
                         class="w-8 h-8 rounded-full">
                    <span class="hidden md:block">{{ auth()->user()->name }}</span>
                    <span class="material-symbols-outlined text-sm">expand_more</span>
                </button>
                
                <div x-show="open" @click.away="open = false" 
                     class="absolute right-0 mt-2 w-48 bg-white rounded-lg shadow-lg py-1 z-50">
                    <a href="{{ route('settings.index') }}" class="block px-4 py-2 text-sm text-gray-700 hover:bg-gray-100">Settings</a>
                    <form method="POST" action="{{ route('logout') }}">
                        @csrf
                        <button type="submit" class="w-full text-left px-4 py-2 text-sm text-gray-700 hover:bg-gray-100">Logout</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
</header>
