@extends('layouts.app')

@section('title', 'Create Opportunity')
@section('page-title', 'Create Opportunity')

@section('content')
<div class="max-w-2xl mx-auto">
    <div class="bg-white rounded-lg shadow p-6">
        <form action="{{ route('opportunities.store') }}" method="POST">
            @csrf

            <div class="mb-4">
                <label for="contact_id" class="block text-sm font-medium text-gray-700 mb-2">Contact</label>
                <select name="contact_id" id="contact_id" required
                    class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
                    <option value="">Select Contact</option>
                    @foreach(\App\Models\Contact::where('company_id', auth()->user()->company_id)->get() as $contact)
                        <option value="{{ $contact->id }}" {{ old('contact_id') == $contact->id ? 'selected' : '' }}>
                            {{ $contact->first_name }} {{ $contact->last_name }}
                        </option>
                    @endforeach
                </select>
                @error('contact_id')
                    <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                @enderror
            </div>

            <div class="mb-4">
                <label for="title" class="block text-sm font-medium text-gray-700 mb-2">Title</label>
                <input type="text" name="title" id="title" value="{{ old('title') }}" required
                    class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
                @error('title')
                    <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                @enderror
            </div>

            <div class="mb-4">
                <label for="description" class="block text-sm font-medium text-gray-700 mb-2">Description</label>
                <textarea name="description" id="description" rows="4"
                    class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">{{ old('description') }}</textarea>
                @error('description')
                    <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                @enderror
            </div>

            <div class="mb-4">
                <label for="value" class="block text-sm font-medium text-gray-700 mb-2">Value</label>
                <input type="number" name="value" id="value" value="{{ old('value') }}" step="0.01"
                    class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
                @error('value')
                    <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                @enderror
            </div>

            <div class="mb-4">
                <label for="stage" class="block text-sm font-medium text-gray-700 mb-2">Stage</label>
                <select name="stage" id="stage"
                    class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
                    <option value="">Select Stage</option>
                    <option value="PROSPECTING" {{ old('stage') === 'PROSPECTING' ? 'selected' : '' }}>Prospecting</option>
                    <option value="QUALIFICATION" {{ old('stage') === 'QUALIFICATION' ? 'selected' : '' }}>Qualification</option>
                    <option value="PROPOSAL" {{ old('stage') === 'PROPOSAL' ? 'selected' : '' }}>Proposal</option>
                    <option value="NEGOTIATION" {{ old('stage') === 'NEGOTIATION' ? 'selected' : '' }}>Negotiation</option>
                    <option value="CLOSED_WON" {{ old('stage') === 'CLOSED_WON' ? 'selected' : '' }}>Closed Won</option>
                    <option value="CLOSED_LOST" {{ old('stage') === 'CLOSED_LOST' ? 'selected' : '' }}>Closed Lost</option>
                </select>
                @error('stage')
                    <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                @enderror
            </div>

            <div class="mb-4">
                <label for="probability" class="block text-sm font-medium text-gray-700 mb-2">Probability (%)</label>
                <input type="number" name="probability" id="probability" value="{{ old('probability') }}" min="0" max="100"
                    class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
                @error('probability')
                    <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                @enderror
            </div>

            <div class="flex gap-4">
                <button type="submit" class="px-4 py-2 bg-blue-600 text-white rounded-lg hover:bg-blue-700">
                    Create Opportunity
                </button>
                <a href="{{ route('opportunities.index') }}" class="px-4 py-2 bg-gray-200 text-gray-700 rounded-lg hover:bg-gray-300">
                    Cancel
                </a>
            </div>
        </form>
    </div>
</div>
@endsection
