@extends('layouts.app')

@section('title', 'Opportunities')
@section('page-title', 'Opportunities')

@section('content')
<div class="flex justify-between items-center mb-6">
    <h1 class="text-2xl font-bold text-gray-800">Opportunities</h1>
    <a href="{{ route('opportunities.create') }}" class="px-4 py-2 bg-blue-600 text-white rounded-lg hover:bg-blue-700">
        <i class="fas fa-plus mr-2"></i> New Opportunity
    </a>
</div>

<div class="bg-white rounded-lg shadow overflow-x-auto">
    <table class="w-full">
        <thead class="bg-gray-50 border-b border-gray-200">
            <tr>
                <th class="px-6 py-3 text-left text-sm font-semibold text-gray-700">Title</th>
                <th class="px-6 py-3 text-left text-sm font-semibold text-gray-700">Contact</th>
                <th class="px-6 py-3 text-left text-sm font-semibold text-gray-700">Value</th>
                <th class="px-6 py-3 text-left text-sm font-semibold text-gray-700">Stage</th>
                <th class="px-6 py-3 text-left text-sm font-semibold text-gray-700">Probability</th>
                <th class="px-6 py-3 text-left text-sm font-semibold text-gray-700">Actions</th>
            </tr>
        </thead>
        <tbody>
            @forelse($opportunities as $opp)
            <tr class="border-b border-gray-200 hover:bg-gray-50">
                <td class="px-6 py-4 text-sm font-medium text-gray-900">{{ $opp->title }}</td>
                <td class="px-6 py-4 text-sm text-gray-600">{{ $opp->contact->first_name }} {{ $opp->contact->last_name }}</td>
                <td class="px-6 py-4 text-sm text-gray-600">${{ number_format($opp->value, 2) }}</td>
                <td class="px-6 py-4 text-sm">
                    <span class="px-3 py-1 text-xs font-semibold rounded-full bg-blue-100 text-blue-800">{{ $opp->stage }}</span>
                </td>
                <td class="px-6 py-4 text-sm text-gray-600">{{ $opp->probability }}%</td>
                <td class="px-6 py-4 text-sm space-x-2">
                    <a href="{{ route('opportunities.show', $opp) }}" class="text-blue-600 hover:text-blue-800">View</a>
                    <a href="{{ route('opportunities.edit', $opp) }}" class="text-green-600 hover:text-green-800">Edit</a>
                </td>
            </tr>
            @empty
            <tr>
                <td colspan="6" class="px-6 py-4 text-center text-gray-500">No opportunities found</td>
            </tr>
            @endforelse
        </tbody>
    </table>
</div>

<div class="mt-4">
    {{ $opportunities->links() }}
</div>
@endsection
