@extends('layouts.app')

@section('title', 'Create Pipeline')
@section('page-title', 'Create New Pipeline')

@section('content')
<div x-data="pipelineForm()" class="max-w-4xl mx-auto">
    <div class="mb-6">
        <a href="{{ route('pipelines.index') }}" class="text-blue-600 hover:text-blue-700 flex items-center gap-2">
            <i class="fas fa-arrow-left"></i>
            Back to Pipelines
        </a>
    </div>

    <form action="{{ route('pipelines.store') }}" method="POST" class="bg-white rounded-lg shadow p-6">
        @csrf

        <!-- Pipeline Details -->
        <div class="mb-6">
            <h2 class="text-lg font-semibold text-gray-900 mb-4">Pipeline Details</h2>
            
            <div class="space-y-4">
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-2">Pipeline Name *</label>
                    <input type="text" name="name" required class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500" placeholder="e.g., Sales Pipeline">
                </div>

                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-2">Description</label>
                    <textarea name="description" rows="3" class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500" placeholder="Describe this pipeline..."></textarea>
                </div>

                <div class="flex items-center gap-2">
                    <input type="checkbox" name="is_default" id="is_default" class="w-4 h-4 text-blue-600 border-gray-300 rounded focus:ring-blue-500">
                    <label for="is_default" class="text-sm text-gray-700">Set as default pipeline</label>
                </div>
            </div>
        </div>

        <!-- Stages -->
        <div class="mb-6">
            <div class="flex items-center justify-between mb-4">
                <h2 class="text-lg font-semibold text-gray-900">Pipeline Stages</h2>
                <button type="button" @click="addStage()" class="px-4 py-2 bg-blue-600 text-white rounded-lg hover:bg-blue-700 text-sm">
                    <i class="fas fa-plus"></i> Add Stage
                </button>
            </div>

            <div class="space-y-3">
                <template x-for="(stage, index) in stages" :key="index">
                    <div class="flex gap-3 items-start p-4 border border-gray-200 rounded-lg">
                        <div class="flex-1 grid grid-cols-3 gap-3">
                            <div>
                                <label class="block text-xs text-gray-600 mb-1">Stage Name *</label>
                                <input type="text" :name="'stages[' + index + '][name]'" x-model="stage.name" required class="w-full px-3 py-2 border border-gray-300 rounded text-sm focus:outline-none focus:ring-2 focus:ring-blue-500">
                            </div>
                            <div>
                                <label class="block text-xs text-gray-600 mb-1">Color *</label>
                                <input type="color" :name="'stages[' + index + '][color]'" x-model="stage.color" required class="w-full h-10 border border-gray-300 rounded cursor-pointer">
                            </div>
                            <div>
                                <label class="block text-xs text-gray-600 mb-1">Win Probability (%) *</label>
                                <input type="number" :name="'stages[' + index + '][win_probability]'" x-model="stage.win_probability" min="0" max="100" required class="w-full px-3 py-2 border border-gray-300 rounded text-sm focus:outline-none focus:ring-2 focus:ring-blue-500">
                            </div>
                        </div>
                        <button type="button" @click="removeStage(index)" x-show="stages.length > 2" class="mt-6 text-red-600 hover:text-red-700">
                            <i class="fas fa-trash"></i>
                        </button>
                    </div>
                </template>
            </div>
        </div>

        <!-- Actions -->
        <div class="flex gap-3 justify-end pt-6 border-t border-gray-200">
            <a href="{{ route('pipelines.index') }}" class="px-6 py-2 border border-gray-300 text-gray-700 rounded-lg hover:bg-gray-50">
                Cancel
            </a>
            <button type="submit" class="px-6 py-2 bg-blue-600 text-white rounded-lg hover:bg-blue-700">
                Create Pipeline
            </button>
        </div>
    </form>
</div>

<script>
function pipelineForm() {
    return {
        stages: [
            { name: 'Lead', color: '#94A3B8', win_probability: 10 },
            { name: 'Qualified', color: '#60A5FA', win_probability: 25 },
            { name: 'Proposal', color: '#34D399', win_probability: 50 },
            { name: 'Negotiation', color: '#FBBF24', win_probability: 75 },
            { name: 'Closed Won', color: '#10B981', win_probability: 100 },
        ],
        
        addStage() {
            this.stages.push({
                name: '',
                color: '#3B82F6',
                win_probability: 50
            });
        },
        
        removeStage(index) {
            this.stages.splice(index, 1);
        }
    }
}
</script>
@endsection
