@extends('layouts.app')

@section('title', 'Edit Pipeline')
@section('page-title', 'Edit Pipeline')

@section('content')
<div class="max-w-4xl mx-auto">
    <div class="mb-6">
        <a href="{{ route('pipelines.show', $pipeline) }}" class="text-blue-600 hover:text-blue-700 flex items-center gap-2">
            <i class="fas fa-arrow-left"></i>
            Back to Pipeline
        </a>
    </div>

    <form action="{{ route('pipelines.update', $pipeline) }}" method="POST" class="bg-white rounded-lg shadow p-6">
        @csrf
        @method('PUT')

        <div class="space-y-6">
            <div>
                <label class="block text-sm font-medium text-gray-700 mb-2">Pipeline Name *</label>
                <input type="text" name="name" value="{{ $pipeline->name }}" required class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
            </div>

            <div>
                <label class="block text-sm font-medium text-gray-700 mb-2">Description</label>
                <textarea name="description" rows="3" class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">{{ $pipeline->description }}</textarea>
            </div>

            <div class="flex items-center gap-2">
                <input type="checkbox" name="is_default" id="is_default" {{ $pipeline->is_default ? 'checked' : '' }} class="w-4 h-4 text-blue-600 border-gray-300 rounded focus:ring-blue-500">
                <label for="is_default" class="text-sm text-gray-700">Set as default pipeline</label>
            </div>
        </div>

        <div class="flex gap-3 justify-end mt-6 pt-6 border-t border-gray-200">
            <a href="{{ route('pipelines.show', $pipeline) }}" class="px-6 py-2 border border-gray-300 text-gray-700 rounded-lg hover:bg-gray-50">
                Cancel
            </a>
            <button type="submit" class="px-6 py-2 bg-blue-600 text-white rounded-lg hover:bg-blue-700">
                Update Pipeline
            </button>
        </div>
    </form>

    <!-- Stages Management -->
    <div class="bg-white rounded-lg shadow p-6 mt-6">
        <h2 class="text-lg font-semibold text-gray-900 mb-4">Manage Stages</h2>
        <p class="text-sm text-gray-600 mb-4">Stages can be managed from the pipeline board view. Drag and drop to reorder stages.</p>
        <a href="{{ route('pipelines.show', $pipeline) }}" class="inline-flex items-center gap-2 px-4 py-2 bg-blue-600 text-white rounded-lg hover:bg-blue-700">
            <i class="fas fa-th-large"></i>
            Go to Board View
        </a>
    </div>
</div>
@endsection
