@extends('layouts.app')

@section('title', 'Pipelines')
@section('page-title', 'Pipelines & Funnels')

@section('content')
<div class="mb-6">
    <div class="flex justify-between items-center">
        <div>
            <h1 class="text-2xl font-bold text-gray-900">Pipelines</h1>
            <p class="text-gray-600 mt-1">Manage your sales pipelines and track deals</p>
        </div>
        <a href="{{ route('pipelines.create') }}" class="px-4 py-2 bg-blue-600 text-white rounded-lg hover:bg-blue-700 flex items-center gap-2">
            <i class="fas fa-plus"></i>
            Create Pipeline
        </a>
    </div>
</div>

<!-- Stats Cards -->
<div class="grid grid-cols-1 md:grid-cols-4 gap-6 mb-6">
    <div class="bg-white rounded-lg shadow p-6">
        <div class="flex items-center justify-between">
            <div>
                <p class="text-sm text-gray-600">Total Pipelines</p>
                <p class="text-2xl font-bold text-gray-900 mt-1">{{ $stats['total_pipelines'] }}</p>
            </div>
            <div class="w-12 h-12 bg-blue-100 rounded-lg flex items-center justify-center">
                <i class="fas fa-stream text-blue-600 text-xl"></i>
            </div>
        </div>
    </div>

    <div class="bg-white rounded-lg shadow p-6">
        <div class="flex items-center justify-between">
            <div>
                <p class="text-sm text-gray-600">Active Deals</p>
                <p class="text-2xl font-bold text-gray-900 mt-1">{{ $stats['total_deals'] }}</p>
            </div>
            <div class="w-12 h-12 bg-green-100 rounded-lg flex items-center justify-center">
                <i class="fas fa-handshake text-green-600 text-xl"></i>
            </div>
        </div>
    </div>

    <div class="bg-white rounded-lg shadow p-6">
        <div class="flex items-center justify-between">
            <div>
                <p class="text-sm text-gray-600">Pipeline Value</p>
                <p class="text-2xl font-bold text-gray-900 mt-1">${{ number_format($stats['total_value'], 0) }}</p>
            </div>
            <div class="w-12 h-12 bg-purple-100 rounded-lg flex items-center justify-center">
                <i class="fas fa-dollar-sign text-purple-600 text-xl"></i>
            </div>
        </div>
    </div>

    <div class="bg-white rounded-lg shadow p-6">
        <div class="flex items-center justify-between">
            <div>
                <p class="text-sm text-gray-600">Won This Month</p>
                <p class="text-2xl font-bold text-gray-900 mt-1">${{ number_format($stats['won_this_month'], 0) }}</p>
            </div>
            <div class="w-12 h-12 bg-yellow-100 rounded-lg flex items-center justify-center">
                <i class="fas fa-trophy text-yellow-600 text-xl"></i>
            </div>
        </div>
    </div>
</div>

<!-- Pipelines List -->
<div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
    @forelse($pipelines as $pipeline)
    <div class="bg-white rounded-lg shadow hover:shadow-lg transition-shadow">
        <div class="p-6">
            <div class="flex items-start justify-between mb-4">
                <div class="flex-1">
                    <div class="flex items-center gap-2">
                        <h3 class="text-lg font-semibold text-gray-900">{{ $pipeline->name }}</h3>
                        @if($pipeline->is_default)
                        <span class="px-2 py-1 bg-blue-100 text-blue-700 text-xs rounded-full">Default</span>
                        @endif
                    </div>
                    @if($pipeline->description)
                    <p class="text-sm text-gray-600 mt-1">{{ $pipeline->description }}</p>
                    @endif
                </div>
            </div>

            <div class="space-y-3 mb-4">
                <div class="flex items-center justify-between text-sm">
                    <span class="text-gray-600">Stages</span>
                    <span class="font-medium text-gray-900">{{ $pipeline->stages->count() }}</span>
                </div>
                <div class="flex items-center justify-between text-sm">
                    <span class="text-gray-600">Active Deals</span>
                    <span class="font-medium text-gray-900">{{ $pipeline->deals_count }}</span>
                </div>
                <div class="flex items-center justify-between text-sm">
                    <span class="text-gray-600">Total Value</span>
                    <span class="font-medium text-gray-900">${{ number_format($pipeline->total_value, 0) }}</span>
                </div>
            </div>

            <div class="flex gap-2">
                <a href="{{ route('pipelines.show', $pipeline) }}" class="flex-1 px-4 py-2 bg-blue-600 text-white text-center rounded-lg hover:bg-blue-700 text-sm">
                    View Board
                </a>
                <a href="{{ route('pipelines.edit', $pipeline) }}" class="px-4 py-2 border border-gray-300 text-gray-700 rounded-lg hover:bg-gray-50 text-sm">
                    <i class="fas fa-edit"></i>
                </a>
            </div>
        </div>
    </div>
    @empty
    <div class="col-span-full bg-white rounded-lg shadow p-12 text-center">
        <i class="fas fa-stream text-gray-300 text-6xl mb-4"></i>
        <h3 class="text-xl font-semibold text-gray-900 mb-2">No Pipelines Yet</h3>
        <p class="text-gray-600 mb-6">Create your first pipeline to start tracking deals</p>
        <a href="{{ route('pipelines.create') }}" class="inline-flex items-center gap-2 px-6 py-3 bg-blue-600 text-white rounded-lg hover:bg-blue-700">
            <i class="fas fa-plus"></i>
            Create Your First Pipeline
        </a>
    </div>
    @endforelse
</div>
@endsection
