@extends('layouts.app')

@section('title', 'Reviews')
@section('page-title', 'Customer Reviews')

@section('content')
<div class="bg-white rounded-lg shadow">
    <div class="px-6 py-4 border-b border-gray-200 flex justify-between items-center">
        <h2 class="text-lg font-semibold text-gray-900">Customer Reviews</h2>
        <a href="{{ route('reviews.create') }}" class="px-4 py-2 bg-blue-600 text-white rounded-lg hover:bg-blue-700">
            + Add Review
        </a>
    </div>

    <div class="overflow-x-auto">
        <table class="w-full">
            <thead class="bg-gray-50 border-b border-gray-200">
                <tr>
                    <th class="px-6 py-3 text-left text-sm font-semibold text-gray-900">Customer</th>
                    <th class="px-6 py-3 text-left text-sm font-semibold text-gray-900">Rating</th>
                    <th class="px-6 py-3 text-left text-sm font-semibold text-gray-900">Comment</th>
                    <th class="px-6 py-3 text-left text-sm font-semibold text-gray-900">Source</th>
                    <th class="px-6 py-3 text-center text-sm font-semibold text-gray-900">Actions</th>
                </tr>
            </thead>
            <tbody>
                @forelse($reviews as $review)
                    <tr class="border-b border-gray-200 hover:bg-gray-50">
                        <td class="px-6 py-4 text-sm text-gray-900">{{ $review->customer_name }}</td>
                        <td class="px-6 py-4 text-sm">
                            <div class="flex items-center">
                                @for($i = 1; $i <= 5; $i++)
                                    <i class="fas fa-star {{ $i <= $review->rating ? 'text-yellow-400' : 'text-gray-300' }}"></i>
                                @endfor
                                <span class="ml-2 text-gray-600">{{ $review->rating }}/5</span>
                            </div>
                        </td>
                        <td class="px-6 py-4 text-sm text-gray-600">{{ Str::limit($review->comment, 50) }}</td>
                        <td class="px-6 py-4 text-sm text-gray-600">{{ $review->source ?? '-' }}</td>
                        <td class="px-6 py-4 text-center">
                            <a href="{{ route('reviews.show', $review->id) }}" class="text-blue-600 hover:text-blue-900 text-sm font-medium">View</a>
                            <a href="{{ route('reviews.edit', $review->id) }}" class="text-blue-600 hover:text-blue-900 text-sm font-medium ml-3">Edit</a>
                            <form action="{{ route('reviews.destroy', $review->id) }}" method="POST" class="inline" onsubmit="return confirm('Delete this review?')">
                                @csrf
                                @method('DELETE')
                                <button type="submit" class="text-red-600 hover:text-red-900 text-sm font-medium ml-3">Delete</button>
                            </form>
                        </td>
                    </tr>
                @empty
                    <tr>
                        <td colspan="5" class="px-6 py-8 text-center text-gray-500">
                            No reviews found
                        </td>
                    </tr>
                @endforelse
            </tbody>
        </table>
    </div>

    @if($reviews->hasPages())
        <div class="px-6 py-4 border-t border-gray-200">
            {{ $reviews->links() }}
        </div>
    @endif
</div>
@endsection
