@extends('layouts.app')

@section('title', 'Team Members')
@section('page-title', 'Team Members')

@section('content')
<div class="mb-6">
    <div class="flex justify-between items-center">
        <div>
            <h1 class="text-2xl font-bold text-gray-900">Team Members</h1>
            <p class="text-gray-600 mt-1">Manage your team and invite new members</p>
        </div>
        <button onclick="openInviteModal()" class="px-4 py-2 bg-blue-600 text-white rounded-lg hover:bg-blue-700 flex items-center gap-2">
            <i class="fas fa-user-plus"></i>
            Invite Team Member
        </button>
    </div>
</div>

<!-- Pending Invitations -->
@if($pendingInvitations->count() > 0)
<div class="bg-yellow-50 border-l-4 border-yellow-400 p-4 mb-6 rounded-lg">
    <div class="flex items-start">
        <i class="fas fa-clock text-yellow-400 mt-1 mr-3"></i>
        <div class="flex-1">
            <h3 class="text-sm font-semibold text-yellow-800 mb-2">Pending Invitations ({{ $pendingInvitations->count() }})</h3>
            <div class="space-y-2">
                @foreach($pendingInvitations as $invitation)
                <div class="flex items-center justify-between bg-white p-3 rounded border border-yellow-200">
                    <div>
                        <p class="text-sm font-medium text-gray-900">{{ $invitation->email }}</p>
                        <p class="text-xs text-gray-600">
                            Invited by {{ $invitation->inviter->name }} • 
                            Expires {{ $invitation->expires_at->diffForHumans() }}
                        </p>
                    </div>
                    <div class="flex gap-2">
                        <form action="{{ route('team.invitation.resend', $invitation->id) }}" method="POST" class="inline">
                            @csrf
                            <button type="submit" class="px-3 py-1 text-xs bg-blue-50 text-blue-600 hover:bg-blue-100 rounded">
                                <i class="fas fa-paper-plane mr-1"></i> Resend
                            </button>
                        </form>
                        <form action="{{ route('team.invitation.cancel', $invitation->id) }}" method="POST" class="inline">
                            @csrf
                            @method('DELETE')
                            <button type="submit" class="px-3 py-1 text-xs bg-red-50 text-red-600 hover:bg-red-100 rounded"
                                    onclick="return confirm('Cancel this invitation?')">
                                <i class="fas fa-times mr-1"></i> Cancel
                            </button>
                        </form>
                    </div>
                </div>
                @endforeach
            </div>
        </div>
    </div>
</div>
@endif

<!-- Team Members Table -->
<div class="bg-white rounded-lg shadow">
    <div class="px-6 py-4 border-b border-gray-200">
        <h2 class="text-lg font-semibold text-gray-900">Active Members ({{ $members->total() }})</h2>
    </div>

    <div class="overflow-x-auto">
        <table class="w-full">
            <thead class="bg-gray-50 border-b border-gray-200">
                <tr>
                    <th class="px-6 py-3 text-left text-sm font-semibold text-gray-900">Member</th>
                    <th class="px-6 py-3 text-left text-sm font-semibold text-gray-900">Contact</th>
                    <th class="px-6 py-3 text-left text-sm font-semibold text-gray-900">Role</th>
                    <th class="px-6 py-3 text-left text-sm font-semibold text-gray-900">Status</th>
                    <th class="px-6 py-3 text-right text-sm font-semibold text-gray-900">Actions</th>
                </tr>
            </thead>
            <tbody>
                @forelse($members as $member)
                    <tr class="border-b border-gray-200 hover:bg-gray-50">
                        <td class="px-6 py-4">
                            <div class="flex items-center gap-3">
                                <div class="w-10 h-10 bg-gradient-to-br from-blue-500 to-purple-600 rounded-full flex items-center justify-center text-white font-semibold">
                                    {{ strtoupper(substr($member->name, 0, 1)) }}
                                </div>
                                <div>
                                    <p class="text-sm font-medium text-gray-900">{{ $member->name }}</p>
                                    @if($member->occupation)
                                    <p class="text-xs text-gray-500">{{ $member->occupation }}</p>
                                    @endif
                                </div>
                            </div>
                        </td>
                        <td class="px-6 py-4">
                            <p class="text-sm text-gray-900">{{ $member->email }}</p>
                            @if($member->phone)
                            <p class="text-xs text-gray-500">{{ $member->phone }}</p>
                            @endif
                        </td>
                        <td class="px-6 py-4">
                            <span class="px-2 py-1 rounded text-xs font-medium bg-blue-100 text-blue-800">
                                {{ ucfirst($member->role ?? 'member') }}
                            </span>
                        </td>
                        <td class="px-6 py-4">
                            <span class="px-2 py-1 rounded text-xs font-medium bg-green-100 text-green-800">
                                <i class="fas fa-circle text-green-500 text-xs mr-1"></i> Active
                            </span>
                        </td>
                        <td class="px-6 py-4 text-right">
                            @if($member->id !== auth()->id())
                            <form action="{{ route('team.remove', $member->id) }}" method="POST" class="inline">
                                @csrf
                                @method('DELETE')
                                <button type="submit" class="text-red-600 hover:text-red-800 text-sm"
                                        onclick="return confirm('Remove {{ $member->name }} from the team?')">
                                    <i class="fas fa-user-minus mr-1"></i> Remove
                                </button>
                            </form>
                            @else
                            <span class="text-xs text-gray-400">You</span>
                            @endif
                        </td>
                    </tr>
                @empty
                    <tr>
                        <td colspan="5" class="px-6 py-12 text-center">
                            <i class="fas fa-users text-gray-300 text-5xl mb-4"></i>
                            <p class="text-gray-500 font-medium">No team members yet</p>
                            <p class="text-sm text-gray-400 mt-1">Invite your first team member to get started</p>
                        </td>
                    </tr>
                @endforelse
            </tbody>
        </table>
    </div>

    @if($members->hasPages())
        <div class="px-6 py-4 border-t border-gray-200">
            {{ $members->links() }}
        </div>
    @endif
</div>

<!-- Invite Modal -->
<div id="inviteModal" class="hidden fixed inset-0 bg-gray-600 bg-opacity-50 overflow-y-auto h-full w-full z-50">
    <div class="relative top-20 mx-auto p-5 border w-96 shadow-lg rounded-md bg-white">
        <div class="flex justify-between items-center mb-4">
            <h3 class="text-lg font-semibold text-gray-900">Invite Team Member</h3>
            <button onclick="closeInviteModal()" class="text-gray-400 hover:text-gray-600">
                <i class="fas fa-times"></i>
            </button>
        </div>

        <form action="{{ route('team.invite') }}" method="POST" class="space-y-4">
            @csrf
            
            <div>
                <label for="email" class="block text-sm font-medium text-gray-700 mb-1">Email Address *</label>
                <input type="email" name="email" id="email" required
                       placeholder="colleague@example.com"
                       class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500">
            </div>

            <div>
                <label for="role" class="block text-sm font-medium text-gray-700 mb-1">Role *</label>
                <select name="role" id="role" required
                        class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500">
                    <option value="member">Member</option>
                    <option value="manager">Manager</option>
                    <option value="admin">Admin</option>
                </select>
                <p class="text-xs text-gray-500 mt-1">Choose the access level for this team member</p>
            </div>

            <div class="flex gap-3 pt-4">
                <button type="button" onclick="closeInviteModal()"
                        class="flex-1 px-4 py-2 border border-gray-300 rounded-md text-gray-700 hover:bg-gray-50">
                    Cancel
                </button>
                <button type="submit"
                        class="flex-1 px-4 py-2 bg-blue-600 text-white rounded-md hover:bg-blue-700">
                    <i class="fas fa-paper-plane mr-2"></i> Send Invitation
                </button>
            </div>
        </form>
    </div>
</div>

<script>
function openInviteModal() {
    document.getElementById('inviteModal').classList.remove('hidden');
}

function closeInviteModal() {
    document.getElementById('inviteModal').classList.add('hidden');
}

// Close modal on outside click
document.getElementById('inviteModal')?.addEventListener('click', function(e) {
    if (e.target === this) {
        closeInviteModal();
    }
});
</script>
@endsection
