@extends('layouts.app')

@section('title', 'Edit User Access - ' . $user->name)

@section('page-title', 'Edit User Access: ' . $user->name)

@section('content')
<div class="bg-white rounded-lg shadow">
    <div class="px-6 py-4 border-b border-gray-200">
        <h2 class="text-lg font-semibold text-gray-900">Module Access for {{ $user->name }}</h2>
        <p class="text-sm text-gray-600 mt-1">{{ $user->email }}</p>
    </div>

    <form action="{{ route('user-access.update', $user) }}" method="POST" class="p-6">
        @csrf
        @method('PUT')

        <div class="space-y-4">
            @foreach($modules as $module)
                <div class="flex items-center justify-between p-4 border border-gray-200 rounded-lg hover:bg-gray-50">
                    <div class="flex items-center space-x-3">
                        @if($module->icon)
                            <span class="material-symbols-outlined text-gray-600">{{ $module->icon }}</span>
                        @endif
                        <div>
                            <p class="font-medium text-gray-900">{{ $module->name }}</p>
                            <p class="text-sm text-gray-500">{{ $module->slug }}</p>
                        </div>
                    </div>

                    <div class="flex items-center space-x-3">
                        <label class="flex items-center space-x-2 cursor-pointer">
                            <input type="radio" name="modules[{{ $module->id }}]" value="allowed" 
                                {{ ($userAccess[$module->id] ?? 'restricted') === 'allowed' ? 'checked' : '' }}
                                class="w-4 h-4">
                            <span class="text-sm font-medium text-green-600">Allowed</span>
                        </label>
                        <label class="flex items-center space-x-2 cursor-pointer">
                            <input type="radio" name="modules[{{ $module->id }}]" value="restricted" 
                                {{ ($userAccess[$module->id] ?? 'restricted') === 'restricted' ? 'checked' : '' }}
                                class="w-4 h-4">
                            <span class="text-sm font-medium text-red-600">Restricted</span>
                        </label>
                    </div>
                </div>
            @endforeach
        </div>

        <div class="mt-6 flex space-x-3">
            <button type="submit" class="px-4 py-2 bg-blue-600 text-white rounded-lg hover:bg-blue-700 font-medium">
                Save Changes
            </button>
            <a href="{{ route('user-access.index') }}" class="px-4 py-2 bg-gray-200 text-gray-900 rounded-lg hover:bg-gray-300 font-medium">
                Cancel
            </a>
        </div>
    </form>
</div>
@endsection
