<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\ContactController;
use App\Http\Controllers\OpportunityController;
use App\Http\Controllers\ConversationController;
use App\Http\Controllers\ActivityController;
use App\Http\Controllers\CampaignController;
use App\Http\Controllers\SocialPostController;
use App\Http\Controllers\EmailCampaignController;
use App\Http\Controllers\AIAgentController;
use App\Http\Controllers\MediaController;
use App\Http\Controllers\CalendarController;
use App\Http\Controllers\ReviewController;
use App\Http\Controllers\SubscriptionController;
use App\Http\Controllers\TeamController;
use App\Http\Controllers\AuditLogController;
use App\Http\Controllers\SettingsController;
use App\Http\Controllers\ProfileController;
use App\Http\Controllers\IntegrationController;
use App\Http\Controllers\AIChatController;
use App\Http\Controllers\GetLateProfileController;
use App\Http\Controllers\GetLatePostController;
use App\Http\Controllers\Social\SocialAccountController;
use App\Http\Controllers\Social\LinkedInController;
use App\Http\Controllers\Social\FacebookController;
use App\Http\Controllers\UserAccessController;
use App\Http\Controllers\UserController;
use App\Http\Controllers\PipelineController;
use App\Http\Controllers\DealController;

// Redirect root to dashboard
Route::get('/', function () {
    return redirect('/dashboard');
});

Route::middleware('auth')->group(function () {
    // Profile
    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');
    
    Route::get('/dashboard', [DashboardController::class, 'index'])->name('dashboard');
    
    // Contacts
    Route::resource('contacts', ContactController::class)->middleware('module.access:contacts');
    
    // Opportunities
    Route::resource('opportunities', OpportunityController::class)->middleware('module.access:opportunities');
    
    // Conversations
    Route::resource('conversations', ConversationController::class)->middleware('module.access:conversations');
    Route::post('conversations/team/send', [ConversationController::class, 'sendTeamMessage'])->name('conversations.send-team-message');
    Route::get('conversations/team/messages', [ConversationController::class, 'getTeamMessages'])->name('conversations.get-team-messages');
    Route::post('conversations/team/voice', [ConversationController::class, 'sendVoiceNote'])->name('conversations.send-voice-note');
    Route::post('conversations/team/typing', [ConversationController::class, 'updateTypingStatus'])->name('conversations.update-typing');
    Route::get('conversations/team/typing', [ConversationController::class, 'getTypingUsers'])->name('conversations.get-typing');
    
    // Activities
    Route::resource('activities', ActivityController::class)->middleware('module.access:activities');
    
    // Campaigns
    Route::resource('campaigns', CampaignController::class)->middleware('module.access:campaigns');
    
    // Social Posts
    Route::resource('social-posts', SocialPostController::class)->middleware('module.access:social-posts');
    
    // Email Campaigns
    Route::resource('email-campaigns', EmailCampaignController::class)->middleware('module.access:email-campaigns');
    Route::post('email-campaigns/{id}/send', [EmailCampaignController::class, 'send'])->name('email-campaigns.send')->middleware('module.access:email-campaigns');
    
    // AI Agents
    Route::resource('ai-agents', AIAgentController::class)->middleware('module.access:ai-agents');
    
    // AI Chat
    Route::get('ai-chat', [AIChatController::class, 'index'])->name('ai-chat.index')->middleware('module.access:ai-agents');
    Route::post('ai-chat/send', [AIChatController::class, 'send'])->name('ai-chat.send')->middleware('module.access:ai-agents');
    
    // Media
    Route::resource('media', MediaController::class)->middleware('module.access:media');
    
    // Calendar
    Route::resource('calendar', CalendarController::class)->middleware('module.access:calendar');
    
    // Reviews
    Route::resource('reviews', ReviewController::class)->middleware('module.access:reviews');
    
    // Subscriptions
    Route::resource('subscriptions', SubscriptionController::class)->middleware('module.access:subscriptions');
    
    // Team
    Route::resource('team', TeamController::class)->middleware('module.access:team');
    Route::post('team/invite', [TeamController::class, 'invite'])->name('team.invite')->middleware('module.access:team');
    Route::post('team/invitation/{id}/resend', [TeamController::class, 'resendInvitation'])->name('team.invitation.resend')->middleware('module.access:team');
    Route::delete('team/invitation/{id}/cancel', [TeamController::class, 'cancelInvitation'])->name('team.invitation.cancel')->middleware('module.access:team');
    Route::delete('team/member/{id}', [TeamController::class, 'removeMember'])->name('team.remove')->middleware('module.access:team');
    
    // Audit Logs
    Route::resource('audit-logs', AuditLogController::class)->only(['index', 'show'])->middleware('module.access:audit-logs');
    
    // Settings
    Route::resource('settings', SettingsController::class)->only(['index', 'update'])->middleware('module.access:settings');
    
    // Integrations
    Route::resource('integrations', IntegrationController::class)->middleware('module.access:integrations');
    
    // GetLate Profiles & Posts
    Route::resource('getlate/profiles', GetLateProfileController::class)->names('getlate.profiles');
    Route::get('getlate/connect/{profileId}/{platform}', [GetLateProfileController::class, 'connect'])->name('getlate.connect');
    Route::post('getlate/profiles/{profile}/connect', [GetLateProfileController::class, 'connectPlatform'])->name('getlate.profiles.connect');
    Route::delete('getlate/profiles/{profileId}/accounts/{accountId}', [GetLateProfileController::class, 'disconnect'])->name('getlate.disconnect');
    Route::get('getlate/posts', [GetLatePostController::class, 'index'])->name('getlate.posts.index');
    Route::get('getlate/posts/create', [GetLatePostController::class, 'create'])->name('getlate.posts.create');
    Route::post('getlate/posts', [GetLatePostController::class, 'store'])->name('getlate.posts.store');
    
    // Social Integrations
    Route::get('/social/accounts', [SocialAccountController::class, 'index'])->name('social.accounts.index');
    Route::delete('/social/accounts/{id}', [SocialAccountController::class, 'destroy'])->name('social.accounts.destroy');
    
    // Pipelines & Deals
    Route::resource('pipelines', PipelineController::class)->middleware('module.access:pipelines');
    Route::post('pipelines/{pipeline}/stages', [PipelineController::class, 'addStage'])->name('pipelines.stages.add');
    Route::put('pipelines/{pipeline}/stages/{stage}', [PipelineController::class, 'updateStage'])->name('pipelines.stages.update');
    Route::delete('pipelines/{pipeline}/stages/{stage}', [PipelineController::class, 'deleteStage'])->name('pipelines.stages.delete');
    Route::put('pipelines/{pipeline}/stages/reorder', [PipelineController::class, 'reorderStages'])->name('pipelines.stages.reorder');
    
    Route::resource('deals', DealController::class)->middleware('module.access:deals');
    Route::put('deals/{deal}/move', [DealController::class, 'move'])->name('deals.move');
    Route::post('deals/{deal}/activities', [DealController::class, 'addActivity'])->name('deals.activities.add');
    Route::put('deals/{deal}/won', [DealController::class, 'markAsWon'])->name('deals.won');
    Route::put('deals/{deal}/lost', [DealController::class, 'markAsLost'])->name('deals.lost');
    
    // User Access Control (Admin only)
    Route::middleware('admin')->group(function () {
        Route::resource('user-access', UserAccessController::class)->only(['index', 'edit', 'update']);
        Route::get('users/create', [UserController::class, 'create'])->name('users.create');
        Route::post('users', [UserController::class, 'store'])->name('users.store');
    });
});

// Social OAuth Callbacks (no auth required)
Route::get('/auth/linkedin/callback', [LinkedInController::class, 'callback'])->name('auth.linkedin.callback');
Route::get('/auth/facebook/callback', [FacebookController::class, 'callback'])->name('auth.facebook.callback');

// Team Invitation (no auth required)
Route::get('/team/invitation/{token}', [TeamController::class, 'acceptInvitation'])->name('team.invitation.accept');
Route::post('/team/invitation/{token}/complete', [TeamController::class, 'completeRegistration'])->name('team.invitation.complete');

require __DIR__.'/auth.php';
