<?php $__env->startSection('title', $campaign->name); ?>
<?php $__env->startSection('page-title', $campaign->name); ?>

<?php $__env->startSection('content'); ?>
<div class="bg-white rounded-lg shadow">
    <div class="px-6 py-4 border-b border-gray-200 flex justify-between items-center">
        <div>
            <h2 class="text-2xl font-bold text-gray-900"><?php echo e($campaign->name); ?></h2>
            <p class="text-sm text-gray-600 mt-1">Subject: <?php echo e($campaign->subject); ?></p>
        </div>
        <div class="flex gap-2">
            <?php if($campaign->status !== 'SENT'): ?>
                <form action="<?php echo e(route('email-campaigns.send', $campaign->id)); ?>" method="POST" class="inline" onsubmit="return confirm('Send this campaign to all recipients?')">
                    <?php echo csrf_field(); ?>
                    <button type="submit" class="px-4 py-2 bg-green-600 text-white rounded-lg hover:bg-green-700">
                        Send Campaign
                    </button>
                </form>
            <?php endif; ?>
            <a href="<?php echo e(route('email-campaigns.edit', $campaign->id)); ?>" class="px-4 py-2 bg-blue-600 text-white rounded-lg hover:bg-blue-700">
                Edit
            </a>
            <form action="<?php echo e(route('email-campaigns.destroy', $campaign->id)); ?>" method="POST" class="inline" onsubmit="return confirm('Delete this campaign?')">
                <?php echo csrf_field(); ?>
                <?php echo method_field('DELETE'); ?>
                <button type="submit" class="px-4 py-2 bg-red-600 text-white rounded-lg hover:bg-red-700">
                    Delete
                </button>
            </form>
        </div>
    </div>

    <div class="p-6 space-y-6">
        <div>
            <h3 class="text-sm font-semibold text-gray-900 mb-2">Status</h3>
            <span class="px-3 py-1 rounded-full text-sm font-medium
                <?php echo e($campaign->status === 'DRAFT' ? 'bg-gray-100 text-gray-800' : ''); ?>

                <?php echo e($campaign->status === 'SCHEDULED' ? 'bg-blue-100 text-blue-800' : ''); ?>

                <?php echo e($campaign->status === 'SENT' ? 'bg-green-100 text-green-800' : ''); ?>

                <?php echo e($campaign->status === 'FAILED' ? 'bg-red-100 text-red-800' : ''); ?>

            ">
                <?php echo e($campaign->status); ?>

            </span>
        </div>

        <div>
            <h3 class="text-sm font-semibold text-gray-900 mb-2">Template</h3>
            <p class="text-gray-700"><?php echo e($campaign->template->name ?? 'N/A'); ?></p>
        </div>

        <div>
            <h3 class="text-sm font-semibold text-gray-900 mb-2">Recipients</h3>
            <div class="bg-gray-50 p-4 rounded-lg border border-gray-200">
                <?php
                    $recipients = is_string($campaign->recipients) ? json_decode($campaign->recipients, true) : $campaign->recipients;
                ?>
                <?php if(is_array($recipients) && count($recipients) > 0): ?>
                    <ul class="text-sm text-gray-700 space-y-1">
                        <?php $__currentLoopData = $recipients; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $recipient): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li><?php echo e($recipient); ?></li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                <?php else: ?>
                    <p class="text-gray-500 text-sm">No recipients</p>
                <?php endif; ?>
            </div>
        </div>

        <div class="text-sm text-gray-500">
            <p>Created: <?php echo e($campaign->created_at->format('M d, Y H:i')); ?></p>
            <p>Updated: <?php echo e($campaign->updated_at->format('M d, Y H:i')); ?></p>
        </div>
    </div>
</div>

<div class="mt-6">
    <a href="<?php echo e(route('email-campaigns.index')); ?>" class="text-blue-600 hover:text-blue-900">
        ← Back to Email Campaigns
    </a>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\projects\sociallead\laravel-backend\resources\views/email-campaigns/show.blade.php ENDPATH**/ ?>