<?php $__env->startSection('title', 'Edit AI Agent - ' . $agent->name); ?>
<?php $__env->startSection('page-title', 'Edit AI Agent: ' . $agent->name); ?>

<?php $__env->startSection('content'); ?>
<div class="max-w-2xl mx-auto">
    <div class="bg-white rounded-lg shadow p-6">
        <form action="<?php echo e(route('ai-agents.update', $agent->id)); ?>" method="POST">
            <?php echo csrf_field(); ?>
            <?php echo method_field('PUT'); ?>

            <div class="mb-4">
                <label for="name" class="block text-sm font-medium text-gray-700 mb-2">Name</label>
                <input type="text" name="name" id="name" value="<?php echo e(old('name', $agent->name)); ?>" required
                    class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
                <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <p class="text-red-500 text-sm mt-1"><?php echo e($message); ?></p>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>

            <div class="mb-4">
                <label for="type" class="block text-sm font-medium text-gray-700 mb-2">Type</label>
                <select name="type" id="type" required
                    class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
                    <option value="">Select Type</option>
                    <option value="LEAD_QUALIFIER" <?php echo e(old('type', $agent->type) === 'LEAD_QUALIFIER' ? 'selected' : ''); ?>>Lead Qualifier</option>
                    <option value="CONTENT_CREATOR" <?php echo e(old('type', $agent->type) === 'CONTENT_CREATOR' ? 'selected' : ''); ?>>Content Creator</option>
                    <option value="CUSTOMER_SUPPORT" <?php echo e(old('type', $agent->type) === 'CUSTOMER_SUPPORT' ? 'selected' : ''); ?>>Customer Support</option>
                    <option value="SALES_ASSISTANT" <?php echo e(old('type', $agent->type) === 'SALES_ASSISTANT' ? 'selected' : ''); ?>>Sales Assistant</option>
                </select>
                <?php $__errorArgs = ['type'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <p class="text-red-500 text-sm mt-1"><?php echo e($message); ?></p>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>

            <div class="mb-4">
                <label for="prompt" class="block text-sm font-medium text-gray-700 mb-2">Prompt</label>
                <textarea name="prompt" id="prompt" rows="10" required
                    class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500"><?php echo e(old('prompt', $agent->prompt)); ?></textarea>
                <?php $__errorArgs = ['prompt'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <p class="text-red-500 text-sm mt-1"><?php echo e($message); ?></p>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>

            <div class="mb-4">
                <label for="model" class="block text-sm font-medium text-gray-700 mb-2">Model</label>
                <select name="model" id="model" required
                    class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
                    <optgroup label="OpenAI">
                        <option value="gpt-4" <?php echo e(old('model', $agent->model) === 'gpt-4' ? 'selected' : ''); ?>>GPT-4</option>
                        <option value="gpt-3.5-turbo" <?php echo e(old('model', $agent->model) === 'gpt-3.5-turbo' ? 'selected' : ''); ?>>GPT-3.5 Turbo</option>
                    </optgroup>
                    <optgroup label="Groq">
                        <option value="llama-3.3-70b-versatile" <?php echo e(old('model', $agent->model) === 'llama-3.3-70b-versatile' ? 'selected' : ''); ?>>Llama 3.3 70B</option>
                        <option value="llama-3.1-8b-instant" <?php echo e(old('model', $agent->model) === 'llama-3.1-8b-instant' ? 'selected' : ''); ?>>Llama 3.1 8B</option>
                        <option value="openai/gpt-oss-120b" <?php echo e(old('model', $agent->model) === 'openai/gpt-oss-120b' ? 'selected' : ''); ?>>GPT OSS 120B</option>
                        <option value="openai/gpt-oss-20b" <?php echo e(old('model', $agent->model) === 'openai/gpt-oss-20b' ? 'selected' : ''); ?>>GPT OSS 20B</option>
                    </optgroup>
                </select>
                <?php $__errorArgs = ['model'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <p class="text-red-500 text-sm mt-1"><?php echo e($message); ?></p>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>

            <div class="mb-4">
                <label class="flex items-center">
                    <input type="checkbox" name="is_active" value="1" <?php echo e(old('is_active', $agent->is_active) ? 'checked' : ''); ?>

                        class="rounded border-gray-300 text-blue-600 shadow-sm focus:ring-blue-500">
                    <span class="ml-2 text-sm text-gray-700">Active</span>
                </label>
                <?php $__errorArgs = ['is_active'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <p class="text-red-500 text-sm mt-1"><?php echo e($message); ?></p>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>

            <div class="flex gap-4">
                <button type="submit" class="px-4 py-2 bg-blue-600 text-white rounded-lg hover:bg-blue-700">
                    Update AI Agent
                </button>
                <a href="<?php echo e(route('ai-agents.index')); ?>" class="px-4 py-2 bg-gray-200 text-gray-700 rounded-lg hover:bg-gray-300">
                    Cancel
                </a>
            </div>
        </form>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\projects\sociallead\laravel-backend\resources\views/ai-agents/edit.blade.php ENDPATH**/ ?>