<?php $__env->startSection('title', 'Edit User Access - ' . $user->name); ?>

<?php $__env->startSection('page-title', 'Edit User Access: ' . $user->name); ?>

<?php $__env->startSection('content'); ?>
<div class="bg-white rounded-lg shadow">
    <div class="px-6 py-4 border-b border-gray-200">
        <h2 class="text-lg font-semibold text-gray-900">Module Access for <?php echo e($user->name); ?></h2>
        <p class="text-sm text-gray-600 mt-1"><?php echo e($user->email); ?></p>
    </div>

    <form action="<?php echo e(route('user-access.update', $user)); ?>" method="POST" class="p-6">
        <?php echo csrf_field(); ?>
        <?php echo method_field('PUT'); ?>

        <div class="space-y-4">
            <?php $__currentLoopData = $modules; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $module): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="flex items-center justify-between p-4 border border-gray-200 rounded-lg hover:bg-gray-50">
                    <div class="flex items-center space-x-3">
                        <?php if($module->icon): ?>
                            <span class="material-symbols-outlined text-gray-600"><?php echo e($module->icon); ?></span>
                        <?php endif; ?>
                        <div>
                            <p class="font-medium text-gray-900"><?php echo e($module->name); ?></p>
                            <p class="text-sm text-gray-500"><?php echo e($module->slug); ?></p>
                        </div>
                    </div>

                    <div class="flex items-center space-x-3">
                        <label class="flex items-center space-x-2 cursor-pointer">
                            <input type="radio" name="modules[<?php echo e($module->id); ?>]" value="allowed" 
                                <?php echo e(($userAccess[$module->id] ?? 'restricted') === 'allowed' ? 'checked' : ''); ?>

                                class="w-4 h-4">
                            <span class="text-sm font-medium text-green-600">Allowed</span>
                        </label>
                        <label class="flex items-center space-x-2 cursor-pointer">
                            <input type="radio" name="modules[<?php echo e($module->id); ?>]" value="restricted" 
                                <?php echo e(($userAccess[$module->id] ?? 'restricted') === 'restricted' ? 'checked' : ''); ?>

                                class="w-4 h-4">
                            <span class="text-sm font-medium text-red-600">Restricted</span>
                        </label>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>

        <div class="mt-6 flex space-x-3">
            <button type="submit" class="px-4 py-2 bg-blue-600 text-white rounded-lg hover:bg-blue-700 font-medium">
                Save Changes
            </button>
            <a href="<?php echo e(route('user-access.index')); ?>" class="px-4 py-2 bg-gray-200 text-gray-900 rounded-lg hover:bg-gray-300 font-medium">
                Cancel
            </a>
        </div>
    </form>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\projects\sociallead\laravel-backend\resources\views/user-access/edit.blade.php ENDPATH**/ ?>