<?php $__env->startSection('title', 'Contact Details'); ?>
<?php $__env->startSection('page-title', 'Contact Details'); ?>

<?php $__env->startSection('content'); ?>
<div class="max-w-4xl mx-auto">
    <div class="flex justify-between items-center mb-6">
        <h1 class="text-2xl font-bold text-gray-800"><?php echo e($contact->first_name); ?> <?php echo e($contact->last_name); ?></h1>
        <div class="space-x-2">
            <a href="<?php echo e(route('contacts.edit', $contact)); ?>" class="px-4 py-2 bg-blue-600 text-white rounded-lg hover:bg-blue-700">Edit</a>
            <form method="POST" action="<?php echo e(route('contacts.destroy', $contact)); ?>" class="inline" onsubmit="return confirm('Are you sure?')">
                <?php echo csrf_field(); ?>
                <?php echo method_field('DELETE'); ?>
                <button type="submit" class="px-4 py-2 bg-red-600 text-white rounded-lg hover:bg-red-700">Delete</button>
            </form>
        </div>
    </div>

    <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
        <div class="lg:col-span-2">
            <div class="bg-white rounded-lg shadow p-6 mb-6">
                <h2 class="text-lg font-semibold text-gray-800 mb-4">Contact Information</h2>
                <div class="grid grid-cols-2 gap-4">
                    <div>
                        <p class="text-sm text-gray-500">Email</p>
                        <p class="text-gray-800"><?php echo e($contact->email); ?></p>
                    </div>
                    <div>
                        <p class="text-sm text-gray-500">Phone</p>
                        <p class="text-gray-800"><?php echo e($contact->phone ?? '-'); ?></p>
                    </div>
                    <div>
                        <p class="text-sm text-gray-500">Job Title</p>
                        <p class="text-gray-800"><?php echo e($contact->job_title ?? '-'); ?></p>
                    </div>
                    <div>
                        <p class="text-sm text-gray-500">Company</p>
                        <p class="text-gray-800"><?php echo e($contact->company_name ?? '-'); ?></p>
                    </div>
                    <div>
                        <p class="text-sm text-gray-500">Status</p>
                        <span class="px-3 py-1 text-xs font-semibold rounded-full bg-blue-100 text-blue-800"><?php echo e($contact->status); ?></span>
                    </div>
                    <div>
                        <p class="text-sm text-gray-500">Source</p>
                        <p class="text-gray-800"><?php echo e($contact->source ?? '-'); ?></p>
                    </div>
                </div>
            </div>

            <div class="bg-white rounded-lg shadow p-6">
                <h2 class="text-lg font-semibold text-gray-800 mb-4">Opportunities</h2>
                <div class="space-y-2">
                    <?php $__empty_1 = true; $__currentLoopData = $contact->opportunities; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $opp): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <div class="flex justify-between items-center p-3 border border-gray-200 rounded">
                        <div>
                            <p class="font-medium text-gray-800"><?php echo e($opp->title); ?></p>
                            <p class="text-sm text-gray-500"><?php echo e($opp->stage); ?></p>
                        </div>
                        <a href="<?php echo e(route('opportunities.show', $opp)); ?>" class="text-blue-600 hover:text-blue-800">View</a>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <p class="text-gray-500">No opportunities</p>
                    <?php endif; ?>
                </div>
            </div>
        </div>

        <div>
            <div class="bg-white rounded-lg shadow p-6">
                <h2 class="text-lg font-semibold text-gray-800 mb-4">Quick Actions</h2>
                <div class="space-y-2">
                    <a href="<?php echo e(route('conversations.create', ['contact_id' => $contact->id])); ?>" class="block w-full px-4 py-2 bg-blue-600 text-white rounded text-center hover:bg-blue-700">
                        <i class="fas fa-comment mr-2"></i> New Conversation
                    </a>
                    <a href="<?php echo e(route('opportunities.create', ['contact_id' => $contact->id])); ?>" class="block w-full px-4 py-2 bg-green-600 text-white rounded text-center hover:bg-green-700">
                        <i class="fas fa-briefcase mr-2"></i> New Opportunity
                    </a>
                    <a href="<?php echo e(route('activities.create', ['contact_id' => $contact->id])); ?>" class="block w-full px-4 py-2 bg-purple-600 text-white rounded text-center hover:bg-purple-700">
                        <i class="fas fa-tasks mr-2"></i> New Activity
                    </a>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\projects\sociallead\laravel-backend\resources\views/contacts/show.blade.php ENDPATH**/ ?>