<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <title>Join Team - <?php echo e(config('app.name')); ?></title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
</head>
<body class="bg-gray-50">
<div class="min-h-screen flex items-center justify-center py-12 px-4 sm:px-6 lg:px-8">
    <div class="max-w-md w-full space-y-8">
        <div>
            <div class="mx-auto h-16 w-16 bg-blue-600 rounded-full flex items-center justify-center">
                <i class="fas fa-users text-white text-2xl"></i>
            </div>
            <h2 class="mt-6 text-center text-3xl font-extrabold text-gray-900">
                Join <?php echo e($invitation->company->name); ?>

            </h2>
            <p class="mt-2 text-center text-sm text-gray-600">
                You've been invited by <strong><?php echo e($invitation->inviter->name); ?></strong>
            </p>
        </div>

        <div class="bg-white shadow rounded-lg p-6">
            <!-- Error Messages -->
            <?php if($errors->any()): ?>
                <div class="mb-6 p-4 bg-red-50 border-l-4 border-red-500 rounded">
                    <div class="flex items-start">
                        <i class="fas fa-exclamation-circle text-red-500 mt-1 mr-3"></i>
                        <div>
                            <h3 class="text-sm font-semibold text-red-800 mb-2">Please fix the following errors:</h3>
                            <ul class="list-disc list-inside text-sm text-red-700">
                                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li><?php echo e($error); ?></li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                        </div>
                    </div>
                </div>
            <?php endif; ?>

            <?php if(session('error')): ?>
                <div class="mb-6 p-4 bg-red-50 border-l-4 border-red-500 rounded">
                    <div class="flex items-start">
                        <i class="fas fa-exclamation-circle text-red-500 mt-1 mr-3"></i>
                        <div>
                            <p class="text-sm text-red-700"><?php echo e(session('error')); ?></p>
                        </div>
                    </div>
                </div>
            <?php endif; ?>

            <div class="mb-6 p-4 bg-blue-50 border-l-4 border-blue-500 rounded">
                <div class="flex items-start">
                    <i class="fas fa-info-circle text-blue-500 mt-1 mr-3"></i>
                    <div>
                        <p class="text-sm text-blue-700">
                            <strong>Company:</strong> <?php echo e($invitation->company->name); ?><br>
                            <strong>Role:</strong> <?php echo e(ucfirst($invitation->role)); ?><br>
                            <strong>Expires:</strong> <?php echo e($invitation->expires_at->diffForHumans()); ?>

                        </p>
                    </div>
                </div>
            </div>

            <form method="POST" action="<?php echo e(route('team.invitation.complete', $invitation->token)); ?>" class="space-y-6">
                <?php echo csrf_field(); ?>
                
                <script>
                    console.log('Form action:', '<?php echo e(route('team.invitation.complete', $invitation->token)); ?>');
                </script>

                <div>
                    <label for="name" class="block text-sm font-medium text-gray-700">Full Name *</label>
                    <input type="text" name="name" id="name" required value="<?php echo e(old('name')); ?>"
                           class="mt-1 block w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-blue-500 focus:border-blue-500">
                    <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <p class="mt-1 text-sm text-red-600"><?php echo e($message); ?></p>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>

                <div>
                    <label for="email" class="block text-sm font-medium text-gray-700">Email Address</label>
                    <input type="email" name="email" id="email" disabled value="<?php echo e($invitation->email); ?>"
                           class="mt-1 block w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm bg-gray-50 text-gray-500">
                    <p class="mt-1 text-xs text-gray-500">This email is pre-filled from your invitation</p>
                </div>

                <div>
                    <label for="occupation" class="block text-sm font-medium text-gray-700">Occupation / Job Title</label>
                    <select name="occupation" id="occupation" 
                            class="mt-1 block w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-blue-500 focus:border-blue-500">
                        <option value="">Select your occupation</option>
                        <optgroup label="Management">
                            <option value="CEO" <?php echo e(old('occupation') == 'CEO' ? 'selected' : ''); ?>>CEO / Chief Executive Officer</option>
                            <option value="COO" <?php echo e(old('occupation') == 'COO' ? 'selected' : ''); ?>>COO / Chief Operating Officer</option>
                            <option value="CTO" <?php echo e(old('occupation') == 'CTO' ? 'selected' : ''); ?>>CTO / Chief Technology Officer</option>
                            <option value="CFO" <?php echo e(old('occupation') == 'CFO' ? 'selected' : ''); ?>>CFO / Chief Financial Officer</option>
                            <option value="General Manager" <?php echo e(old('occupation') == 'General Manager' ? 'selected' : ''); ?>>General Manager</option>
                            <option value="Project Manager" <?php echo e(old('occupation') == 'Project Manager' ? 'selected' : ''); ?>>Project Manager</option>
                        </optgroup>
                        <optgroup label="Marketing & Sales">
                            <option value="Marketing Manager" <?php echo e(old('occupation') == 'Marketing Manager' ? 'selected' : ''); ?>>Marketing Manager</option>
                            <option value="Digital Marketing Specialist" <?php echo e(old('occupation') == 'Digital Marketing Specialist' ? 'selected' : ''); ?>>Digital Marketing Specialist</option>
                            <option value="Social Media Manager" <?php echo e(old('occupation') == 'Social Media Manager' ? 'selected' : ''); ?>>Social Media Manager</option>
                            <option value="Content Creator" <?php echo e(old('occupation') == 'Content Creator' ? 'selected' : ''); ?>>Content Creator</option>
                            <option value="Sales Manager" <?php echo e(old('occupation') == 'Sales Manager' ? 'selected' : ''); ?>>Sales Manager</option>
                            <option value="Sales Representative" <?php echo e(old('occupation') == 'Sales Representative' ? 'selected' : ''); ?>>Sales Representative</option>
                            <option value="Business Development Manager" <?php echo e(old('occupation') == 'Business Development Manager' ? 'selected' : ''); ?>>Business Development Manager</option>
                        </optgroup>
                        <optgroup label="Technology">
                            <option value="Software Developer" <?php echo e(old('occupation') == 'Software Developer' ? 'selected' : ''); ?>>Software Developer</option>
                            <option value="Full Stack Developer" <?php echo e(old('occupation') == 'Full Stack Developer' ? 'selected' : ''); ?>>Full Stack Developer</option>
                            <option value="Frontend Developer" <?php echo e(old('occupation') == 'Frontend Developer' ? 'selected' : ''); ?>>Frontend Developer</option>
                            <option value="Backend Developer" <?php echo e(old('occupation') == 'Backend Developer' ? 'selected' : ''); ?>>Backend Developer</option>
                            <option value="DevOps Engineer" <?php echo e(old('occupation') == 'DevOps Engineer' ? 'selected' : ''); ?>>DevOps Engineer</option>
                            <option value="Data Analyst" <?php echo e(old('occupation') == 'Data Analyst' ? 'selected' : ''); ?>>Data Analyst</option>
                            <option value="UI/UX Designer" <?php echo e(old('occupation') == 'UI/UX Designer' ? 'selected' : ''); ?>>UI/UX Designer</option>
                        </optgroup>
                        <optgroup label="Customer Service">
                            <option value="Customer Support Manager" <?php echo e(old('occupation') == 'Customer Support Manager' ? 'selected' : ''); ?>>Customer Support Manager</option>
                            <option value="Customer Service Representative" <?php echo e(old('occupation') == 'Customer Service Representative' ? 'selected' : ''); ?>>Customer Service Representative</option>
                            <option value="Account Manager" <?php echo e(old('occupation') == 'Account Manager' ? 'selected' : ''); ?>>Account Manager</option>
                        </optgroup>
                        <optgroup label="Finance & Operations">
                            <option value="Accountant" <?php echo e(old('occupation') == 'Accountant' ? 'selected' : ''); ?>>Accountant</option>
                            <option value="Financial Analyst" <?php echo e(old('occupation') == 'Financial Analyst' ? 'selected' : ''); ?>>Financial Analyst</option>
                            <option value="Operations Manager" <?php echo e(old('occupation') == 'Operations Manager' ? 'selected' : ''); ?>>Operations Manager</option>
                            <option value="HR Manager" <?php echo e(old('occupation') == 'HR Manager' ? 'selected' : ''); ?>>HR Manager</option>
                        </optgroup>
                        <optgroup label="Other">
                            <option value="Consultant" <?php echo e(old('occupation') == 'Consultant' ? 'selected' : ''); ?>>Consultant</option>
                            <option value="Freelancer" <?php echo e(old('occupation') == 'Freelancer' ? 'selected' : ''); ?>>Freelancer</option>
                            <option value="Intern" <?php echo e(old('occupation') == 'Intern' ? 'selected' : ''); ?>>Intern</option>
                            <option value="Other" <?php echo e(old('occupation') == 'Other' ? 'selected' : ''); ?>>Other</option>
                        </optgroup>
                    </select>
                    <?php $__errorArgs = ['occupation'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <p class="mt-1 text-sm text-red-600"><?php echo e($message); ?></p>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>

                <div>
                    <label for="phone" class="block text-sm font-medium text-gray-700">Phone Number</label>
                    <input type="tel" name="phone" id="phone" value="<?php echo e(old('phone')); ?>"
                           placeholder="+1 (555) 123-4567"
                           class="mt-1 block w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-blue-500 focus:border-blue-500">
                    <?php $__errorArgs = ['phone'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <p class="mt-1 text-sm text-red-600"><?php echo e($message); ?></p>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>

                <div>
                    <label for="bio" class="block text-sm font-medium text-gray-700">Bio / About You</label>
                    <textarea name="bio" id="bio" rows="3" 
                              placeholder="Tell us a bit about yourself..."
                              class="mt-1 block w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-blue-500 focus:border-blue-500"><?php echo e(old('bio')); ?></textarea>
                    <p class="mt-1 text-xs text-gray-500">Maximum 500 characters</p>
                    <?php $__errorArgs = ['bio'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <p class="mt-1 text-sm text-red-600"><?php echo e($message); ?></p>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>

                <div>
                    <label for="password" class="block text-sm font-medium text-gray-700">Password *</label>
                    <input type="password" name="password" id="password" required
                           class="mt-1 block w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-blue-500 focus:border-blue-500">
                    <p class="mt-1 text-xs text-gray-500">Minimum 8 characters</p>
                    <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <p class="mt-1 text-sm text-red-600"><?php echo e($message); ?></p>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>

                <div>
                    <label for="password_confirmation" class="block text-sm font-medium text-gray-700">Confirm Password *</label>
                    <input type="password" name="password_confirmation" id="password_confirmation" required
                           class="mt-1 block w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-blue-500 focus:border-blue-500">
                </div>

                <div>
                    <button type="submit" class="w-full flex justify-center py-3 px-4 border border-transparent rounded-md shadow-sm text-sm font-medium text-white bg-blue-600 hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500">
                        <i class="fas fa-check-circle mr-2 mt-0.5"></i>
                        Complete Registration & Join Team
                    </button>
                </div>
            </form>
        </div>

        <p class="text-center text-xs text-gray-500">
            By joining, you agree to our Terms of Service and Privacy Policy
        </p>
    </div>
</div>
</body>
</html>
<?php /**PATH C:\projects\sociallead\laravel-backend\resources\views/team/accept-invitation.blade.php ENDPATH**/ ?>