<?php $__env->startSection('title', 'Dashboard'); ?>
<?php $__env->startSection('page-title', 'Dashboard'); ?>

<?php $__env->startSection('content'); ?>
<div class="grid grid-cols-1 md:grid-cols-4 gap-6 mb-6">
    <div class="bg-white rounded-lg shadow p-6">
        <div class="flex items-center justify-between">
            <div>
                <p class="text-gray-500 text-sm">Total Contacts</p>
                <p class="text-3xl font-bold text-gray-800"><?php echo e($totalContacts ?? 0); ?></p>
            </div>
            <i class="fas fa-users text-4xl text-blue-500 opacity-20"></i>
        </div>
    </div>

    <div class="bg-white rounded-lg shadow p-6">
        <div class="flex items-center justify-between">
            <div>
                <p class="text-gray-500 text-sm">Open Opportunities</p>
                <p class="text-3xl font-bold text-gray-800"><?php echo e($openOpportunities ?? 0); ?></p>
            </div>
            <i class="fas fa-briefcase text-4xl text-green-500 opacity-20"></i>
        </div>
    </div>

    <div class="bg-white rounded-lg shadow p-6">
        <div class="flex items-center justify-between">
            <div>
                <p class="text-gray-500 text-sm">Active Campaigns</p>
                <p class="text-3xl font-bold text-gray-800"><?php echo e($activeCampaigns ?? 0); ?></p>
            </div>
            <i class="fas fa-bullhorn text-4xl text-purple-500 opacity-20"></i>
        </div>
    </div>

    <div class="bg-white rounded-lg shadow p-6">
        <div class="flex items-center justify-between">
            <div>
                <p class="text-gray-500 text-sm">Pending Tasks</p>
                <p class="text-3xl font-bold text-gray-800"><?php echo e($pendingTasks ?? 0); ?></p>
            </div>
            <i class="fas fa-tasks text-4xl text-orange-500 opacity-20"></i>
        </div>
    </div>
</div>

<div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
    <div class="lg:col-span-2 bg-white rounded-lg shadow p-6">
        <h3 class="text-lg font-semibold text-gray-800 mb-4">Recent Contacts</h3>
        <div class="overflow-x-auto">
            <table class="w-full">
                <thead class="bg-gray-50">
                    <tr>
                        <th class="px-4 py-2 text-left text-sm font-semibold text-gray-700">Name</th>
                        <th class="px-4 py-2 text-left text-sm font-semibold text-gray-700">Email</th>
                        <th class="px-4 py-2 text-left text-sm font-semibold text-gray-700">Status</th>
                        <th class="px-4 py-2 text-left text-sm font-semibold text-gray-700">Action</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $recentContacts ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $contact): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr class="border-t">
                        <td class="px-4 py-3 text-sm"><?php echo e($contact->first_name); ?> <?php echo e($contact->last_name); ?></td>
                        <td class="px-4 py-3 text-sm"><?php echo e($contact->email); ?></td>
                        <td class="px-4 py-3 text-sm">
                            <span class="px-2 py-1 text-xs font-semibold rounded-full bg-blue-100 text-blue-800"><?php echo e($contact->status); ?></span>
                        </td>
                        <td class="px-4 py-3 text-sm">
                            <a href="<?php echo e(route('contacts.show', $contact)); ?>" class="text-blue-600 hover:text-blue-800">View</a>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr class="border-t">
                        <td colspan="4" class="px-4 py-3 text-center text-gray-500">No contacts yet</td>
                    </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>

    <div class="bg-white rounded-lg shadow p-6">
        <h3 class="text-lg font-semibold text-gray-800 mb-4">Quick Actions</h3>
        <div class="space-y-2">
            <a href="<?php echo e(route('contacts.create')); ?>" class="block w-full px-4 py-2 bg-blue-600 text-white rounded hover:bg-blue-700 text-center">
                <i class="fas fa-plus mr-2"></i> New Contact
            </a>
            <a href="<?php echo e(route('opportunities.create')); ?>" class="block w-full px-4 py-2 bg-green-600 text-white rounded hover:bg-green-700 text-center">
                <i class="fas fa-plus mr-2"></i> New Opportunity
            </a>
            <a href="<?php echo e(route('campaigns.create')); ?>" class="block w-full px-4 py-2 bg-purple-600 text-white rounded hover:bg-purple-700 text-center">
                <i class="fas fa-plus mr-2"></i> New Campaign
            </a>
            <a href="<?php echo e(route('email-campaigns.create')); ?>" class="block w-full px-4 py-2 bg-orange-600 text-white rounded hover:bg-orange-700 text-center">
                <i class="fas fa-plus mr-2"></i> Email Campaign
            </a>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\projects\sociallead\laravel-backend\resources\views/dashboard.blade.php ENDPATH**/ ?>