<?php $__env->startSection('title', 'Create AI Agent'); ?>
<?php $__env->startSection('page-title', 'Create AI Agent'); ?>

<?php $__env->startSection('content'); ?>
<div class="max-w-2xl mx-auto">
    <div class="bg-white rounded-lg shadow p-6">
        <form action="<?php echo e(route('ai-agents.store')); ?>" method="POST">
            <?php echo csrf_field(); ?>

            <div class="mb-4">
                <label for="name" class="block text-sm font-medium text-gray-700 mb-2">Name</label>
                <input type="text" name="name" id="name" value="<?php echo e(old('name')); ?>" required
                    class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
                <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <p class="text-red-500 text-sm mt-1"><?php echo e($message); ?></p>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>

            <div class="mb-4">
                <label for="type" class="block text-sm font-medium text-gray-700 mb-2">Type</label>
                <select name="type" id="type" required
                    class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
                    <option value="">Select Type</option>
                    <option value="LEAD_QUALIFIER" <?php echo e(old('type') === 'LEAD_QUALIFIER' ? 'selected' : ''); ?>>Lead Qualifier</option>
                    <option value="CONTENT_CREATOR" <?php echo e(old('type') === 'CONTENT_CREATOR' ? 'selected' : ''); ?>>Content Creator</option>
                    <option value="CUSTOMER_SUPPORT" <?php echo e(old('type') === 'CUSTOMER_SUPPORT' ? 'selected' : ''); ?>>Customer Support</option>
                    <option value="SALES_ASSISTANT" <?php echo e(old('type') === 'SALES_ASSISTANT' ? 'selected' : ''); ?>>Sales Assistant</option>
                </select>
                <?php $__errorArgs = ['type'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <p class="text-red-500 text-sm mt-1"><?php echo e($message); ?></p>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>

            <div class="mb-4">
                <label for="prompt" class="block text-sm font-medium text-gray-700 mb-2">Prompt</label>
                <textarea name="prompt" id="prompt" rows="10" required
                    class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500"><?php echo e(old('prompt')); ?></textarea>
                <?php $__errorArgs = ['prompt'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <p class="text-red-500 text-sm mt-1"><?php echo e($message); ?></p>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>

            <div class="mb-4">
                <label for="model" class="block text-sm font-medium text-gray-700 mb-2">Model</label>
                <select name="model" id="model" required
                    class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
                    <optgroup label="OpenAI">
                        <option value="gpt-4" <?php echo e(old('model', 'gpt-4') === 'gpt-4' ? 'selected' : ''); ?>>GPT-4</option>
                        <option value="gpt-3.5-turbo" <?php echo e(old('model') === 'gpt-3.5-turbo' ? 'selected' : ''); ?>>GPT-3.5 Turbo</option>
                    </optgroup>
                    <optgroup label="Groq">
                        <option value="llama-3.3-70b-versatile" <?php echo e(old('model') === 'llama-3.3-70b-versatile' ? 'selected' : ''); ?>>Llama 3.3 70B</option>
                        <option value="llama-3.1-8b-instant" <?php echo e(old('model') === 'llama-3.1-8b-instant' ? 'selected' : ''); ?>>Llama 3.1 8B</option>
                        <option value="openai/gpt-oss-120b" <?php echo e(old('model') === 'openai/gpt-oss-120b' ? 'selected' : ''); ?>>GPT OSS 120B</option>
                        <option value="openai/gpt-oss-20b" <?php echo e(old('model') === 'openai/gpt-oss-20b' ? 'selected' : ''); ?>>GPT OSS 20B</option>
                    </optgroup>
                </select>
                <?php $__errorArgs = ['model'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <p class="text-red-500 text-sm mt-1"><?php echo e($message); ?></p>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>

            <div class="mb-4">
                <label class="flex items-center">
                    <input type="checkbox" name="is_active" value="1" <?php echo e(old('is_active', true) ? 'checked' : ''); ?>

                        class="rounded border-gray-300 text-blue-600 shadow-sm focus:ring-blue-500">
                    <span class="ml-2 text-sm text-gray-700">Active</span>
                </label>
                <?php $__errorArgs = ['is_active'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <p class="text-red-500 text-sm mt-1"><?php echo e($message); ?></p>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>

            <div class="flex gap-4">
                <button type="submit" class="px-4 py-2 bg-blue-600 text-white rounded-lg hover:bg-blue-700">
                    Create AI Agent
                </button>
                <a href="<?php echo e(route('ai-agents.index')); ?>" class="px-4 py-2 bg-gray-200 text-gray-700 rounded-lg hover:bg-gray-300">
                    Cancel
                </a>
            </div>
        </form>
    </div>
</div>

<script>
const agentPrompts = {
    LEAD_QUALIFIER: `You are a lead qualification specialist for Wolke Consultancy LLC, a Houston-based technology consulting and digital marketing firm serving businesses globally (excluding India, South Africa, Nepal, Japan, China, Hong Kong, Pakistan, Afghanistan).

COMPANY CONTEXT:
- Founded 2019, 10-50 employees
- Mission: Empowering organizations to achieve growth through cutting-edge technology, data-driven marketing, and digital transformation
- Services: WolkeAI Suite, Custom Tech Development (CRM, ERP, Odoo, Mobile Apps, MERN/MEAN Stack), Digital Marketing
- Pricing: SaaS from $99/mo, Custom projects from $500+, Marketing retainers from $500/mo
- Industries: ALL sectors

IDEAL CUSTOMER PROFILE:
- Any business size (1-500+ employees) with tech-related needs
- Decision-makers: CEO, CTO, CMO, Marketing Director, Operations Manager, IT Lead, Founders
- Pain Points: Manual processes, scaling challenges, system upgrades, integration issues, digital transformation needs
- Budget: $500 to unlimited

YOUR ROLE:
1. Quickly identify the prospect's tech/marketing need or "want" for upgrade/innovation
2. Determine project scope: single upgrade vs. full digital transformation
3. Assess urgency and timeline
4. Qualify budget alignment ($500+ minimum)
5. Identify decision-making authority

QUALIFICATION SCORING:
- HOT (9-10): Clear need, budget $5K+, decision-maker, urgent timeline, multiple services needed
- WARM (6-8): Defined need, budget $500-5K, exploring options, 30-90 day timeline
- COLD (1-5): Vague need, budget unclear/insufficient, no authority, no timeline

Always be professional, consultative, and focus on understanding their "want" for tech advancement.`,

    CONTENT_CREATOR: `You create content for Wolke Consultancy LLC, a Houston-based tech consulting and digital marketing firm.

Company: WolkeAI Suite (AI automation), Custom Development (CRM, ERP, Odoo, Mobile Apps, Web), Digital Marketing (SEO, Social, Ads). Serves all industries globally. Pricing: $99/mo to enterprise custom builds.

Create social posts, emails, blogs, ad copy, and product descriptions. Target CEOs, CTOs, CMOs, Founders dealing with manual processes, scaling issues, or digital transformation needs.

Key message: "Whenever you WANT to upgrade or innovate anything tech-related" - emphasize AI-first approach and comprehensive solutions.

Write conversationally. No excessive formatting. Include clear CTAs like "Schedule consultation" or "Start free trial."`,

    CUSTOMER_SUPPORT: `You are a customer support specialist for Wolke Consultancy LLC, providing exceptional service for our technology and marketing solutions.

COMPANY CONTEXT:
- Services: WolkeAI Suite, Custom Development, Digital Marketing
- Website: www.wolkeconsultancy.com
- Support: Multichannel (email, phone, chat), dedicated onboarding manager, full platform training

YOUR ROLE:
1. Provide prompt, professional support for technical issues, feature questions, billing, and training
2. Common Issues: Login/access, integrations, performance, billing
3. Escalation Triggers: Custom dev scope changes, billing disputes over $500, security concerns, critical bugs

SUPPORT STANDARDS:
- First response within 2 minutes during business hours
- Resolution-focused approach with clear next steps
- Proactive updates on ticket status

Be direct, clear, and helpful. Get straight to the solution.`,

    SALES_ASSISTANT: `You are a sales specialist for Wolke Consultancy LLC, a Houston-based technology consulting and digital marketing firm.

SERVICES & PRICING:
1. WolkeAI Suite: $99-$999/mo
2. Custom Development: $500+ (project-based) or $150-$200/hour
3. Digital Marketing: $500-$10,000+/month

TARGET CUSTOMERS:
- ALL industries globally
- Company size: 1-500+ employees
- Decision-makers: CEO, CTO, CMO, Marketing Director, Operations Manager

YOUR SALES APPROACH:
1. DISCOVERY: Identify their tech/marketing "want" or need
2. SOLUTION PRESENTATION: Match their need to our services
3. VALUE DEMONSTRATION: Emphasize AI-first approach and ROI
4. OBJECTION HANDLING: Address concerns with solutions
5. CLOSING: Schedule consultation / Start free trial / Get custom quote`
};

document.getElementById('type').addEventListener('change', function() {
    const promptField = document.getElementById('prompt');
    if (this.value && agentPrompts[this.value]) {
        promptField.value = agentPrompts[this.value];
    }
});
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\projects\sociallead\laravel-backend\resources\views/ai-agents/create.blade.php ENDPATH**/ ?>