<?php $__env->startSection('title', 'Contacts'); ?>
<?php $__env->startSection('page-title', 'Contacts'); ?>

<?php $__env->startSection('content'); ?>
<div class="flex justify-between items-center mb-6">
    <h1 class="text-2xl font-bold text-gray-800">Contacts</h1>
    <a href="<?php echo e(route('contacts.create')); ?>" class="px-4 py-2 bg-blue-600 text-white rounded-lg hover:bg-blue-700">
        <i class="fas fa-plus mr-2"></i> New Contact
    </a>
</div>

<div class="bg-white rounded-lg shadow">
    <div class="p-6 border-b border-gray-200">
        <div class="flex gap-4">
            <input type="text" placeholder="Search contacts..." class="flex-1 px-4 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
            <select class="px-4 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
                <option value="">All Status</option>
                <option value="LEAD">Lead</option>
                <option value="PROSPECT">Prospect</option>
                <option value="CUSTOMER">Customer</option>
                <option value="INACTIVE">Inactive</option>
            </select>
        </div>
    </div>

    <div class="overflow-x-auto">
        <table class="w-full">
            <thead class="bg-gray-50 border-b border-gray-200">
                <tr>
                    <th class="px-6 py-3 text-left text-sm font-semibold text-gray-700">Name</th>
                    <th class="px-6 py-3 text-left text-sm font-semibold text-gray-700">Email</th>
                    <th class="px-6 py-3 text-left text-sm font-semibold text-gray-700">Phone</th>
                    <th class="px-6 py-3 text-left text-sm font-semibold text-gray-700">Company</th>
                    <th class="px-6 py-3 text-left text-sm font-semibold text-gray-700">Status</th>
                    <th class="px-6 py-3 text-left text-sm font-semibold text-gray-700">Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php $__empty_1 = true; $__currentLoopData = $contacts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $contact): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <tr class="border-b border-gray-200 hover:bg-gray-50">
                    <td class="px-6 py-4 text-sm font-medium text-gray-900"><?php echo e($contact->first_name); ?> <?php echo e($contact->last_name); ?></td>
                    <td class="px-6 py-4 text-sm text-gray-600"><?php echo e($contact->email); ?></td>
                    <td class="px-6 py-4 text-sm text-gray-600"><?php echo e($contact->phone ?? '-'); ?></td>
                    <td class="px-6 py-4 text-sm text-gray-600"><?php echo e($contact->company_name ?? '-'); ?></td>
                    <td class="px-6 py-4 text-sm">
                        <span class="px-3 py-1 text-xs font-semibold rounded-full 
                            <?php if($contact->status === 'LEAD'): ?> bg-blue-100 text-blue-800
                            <?php elseif($contact->status === 'PROSPECT'): ?> bg-yellow-100 text-yellow-800
                            <?php elseif($contact->status === 'CUSTOMER'): ?> bg-green-100 text-green-800
                            <?php else: ?> bg-gray-100 text-gray-800
                            <?php endif; ?>">
                            <?php echo e($contact->status); ?>

                        </span>
                    </td>
                    <td class="px-6 py-4 text-sm space-x-2">
                        <a href="<?php echo e(route('contacts.show', $contact)); ?>" class="text-blue-600 hover:text-blue-800">View</a>
                        <a href="<?php echo e(route('contacts.edit', $contact)); ?>" class="text-green-600 hover:text-green-800">Edit</a>
                        <form method="POST" action="<?php echo e(route('contacts.destroy', $contact)); ?>" class="inline" onsubmit="return confirm('Are you sure?')">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('DELETE'); ?>
                            <button type="submit" class="text-red-600 hover:text-red-800">Delete</button>
                        </form>
                    </td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <tr>
                    <td colspan="6" class="px-6 py-4 text-center text-gray-500">No contacts found</td>
                </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>

    <div class="px-6 py-4 border-t border-gray-200">
        <?php echo e($contacts->links()); ?>

    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\projects\sociallead\laravel-backend\resources\views/contacts/index.blade.php ENDPATH**/ ?>