<?php $__env->startSection('title', 'Review - ' . $review->customer_name); ?>
<?php $__env->startSection('page-title', 'Review from ' . $review->customer_name); ?>

<?php $__env->startSection('content'); ?>
<div class="bg-white rounded-lg shadow">
    <div class="px-6 py-4 border-b border-gray-200 flex justify-between items-center">
        <div>
            <h2 class="text-2xl font-bold text-gray-900"><?php echo e($review->customer_name); ?></h2>
        </div>
        <div class="flex gap-2">
            <a href="<?php echo e(route('reviews.edit', $review->id)); ?>" class="px-4 py-2 bg-blue-600 text-white rounded-lg hover:bg-blue-700">
                Edit
            </a>
            <form action="<?php echo e(route('reviews.destroy', $review->id)); ?>" method="POST" class="inline" onsubmit="return confirm('Delete this review?')">
                <?php echo csrf_field(); ?>
                <?php echo method_field('DELETE'); ?>
                <button type="submit" class="px-4 py-2 bg-red-600 text-white rounded-lg hover:bg-red-700">
                    Delete
                </button>
            </form>
        </div>
    </div>

    <div class="p-6 space-y-6">
        <div>
            <h3 class="text-sm font-semibold text-gray-900 mb-2">Rating</h3>
            <div class="flex items-center">
                <?php for($i = 1; $i <= 5; $i++): ?>
                    <i class="fas fa-star <?php echo e($i <= $review->rating ? 'text-yellow-400' : 'text-gray-300'); ?> text-lg"></i>
                <?php endfor; ?>
                <span class="ml-3 text-lg font-semibold text-gray-900"><?php echo e($review->rating); ?>/5</span>
            </div>
        </div>

        <div>
            <h3 class="text-sm font-semibold text-gray-900 mb-2">Comment</h3>
            <p class="text-gray-700"><?php echo e($review->comment ?? 'No comment'); ?></p>
        </div>

        <?php if($review->source): ?>
            <div>
                <h3 class="text-sm font-semibold text-gray-900 mb-2">Source</h3>
                <p class="text-gray-700"><?php echo e($review->source); ?></p>
            </div>
        <?php endif; ?>

        <div class="text-sm text-gray-500">
            <p>Created: <?php echo e($review->created_at->format('M d, Y H:i')); ?></p>
            <p>Updated: <?php echo e($review->updated_at->format('M d, Y H:i')); ?></p>
        </div>
    </div>
</div>

<div class="mt-6">
    <a href="<?php echo e(route('reviews.index')); ?>" class="text-blue-600 hover:text-blue-900">
        ← Back to Reviews
    </a>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\projects\sociallead\laravel-backend\resources\views/reviews/show.blade.php ENDPATH**/ ?>