<?php $__env->startSection('title', 'Email Campaigns'); ?>
<?php $__env->startSection('page-title', 'Email Campaigns'); ?>

<?php $__env->startSection('content'); ?>
<div class="bg-white rounded-lg shadow">
    <div class="px-6 py-4 border-b border-gray-200 flex justify-between items-center">
        <h2 class="text-lg font-semibold text-gray-900">Email Campaigns</h2>
        <a href="<?php echo e(route('email-campaigns.create')); ?>" class="px-4 py-2 bg-blue-600 text-white rounded-lg hover:bg-blue-700">
            + Create Campaign
        </a>
    </div>

    <div class="overflow-x-auto">
        <table class="w-full">
            <thead class="bg-gray-50 border-b border-gray-200">
                <tr>
                    <th class="px-6 py-3 text-left text-sm font-semibold text-gray-900">Name</th>
                    <th class="px-6 py-3 text-left text-sm font-semibold text-gray-900">Subject</th>
                    <th class="px-6 py-3 text-left text-sm font-semibold text-gray-900">Status</th>
                    <th class="px-6 py-3 text-left text-sm font-semibold text-gray-900">Created By</th>
                    <th class="px-6 py-3 text-center text-sm font-semibold text-gray-900">Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php $__empty_1 = true; $__currentLoopData = $campaigns; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $campaign): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr class="border-b border-gray-200 hover:bg-gray-50">
                        <td class="px-6 py-4 text-sm text-gray-900"><?php echo e($campaign->name); ?></td>
                        <td class="px-6 py-4 text-sm text-gray-600"><?php echo e($campaign->subject); ?></td>
                        <td class="px-6 py-4 text-sm">
                            <span class="px-2 py-1 rounded text-xs font-medium
                                <?php echo e($campaign->status === 'DRAFT' ? 'bg-gray-100 text-gray-800' : ''); ?>

                                <?php echo e($campaign->status === 'SCHEDULED' ? 'bg-blue-100 text-blue-800' : ''); ?>

                                <?php echo e($campaign->status === 'SENT' ? 'bg-green-100 text-green-800' : ''); ?>

                                <?php echo e($campaign->status === 'FAILED' ? 'bg-red-100 text-red-800' : ''); ?>

                            ">
                                <?php echo e($campaign->status); ?>

                            </span>
                        </td>
                        <td class="px-6 py-4 text-sm text-gray-600"><?php echo e($campaign->user->name ?? 'N/A'); ?></td>
                        <td class="px-6 py-4 text-center">
                            <a href="<?php echo e(route('email-campaigns.show', $campaign)); ?>" class="text-blue-600 hover:text-blue-900 text-sm font-medium">View</a>
                            <a href="<?php echo e(route('email-campaigns.edit', $campaign)); ?>" class="text-blue-600 hover:text-blue-900 text-sm font-medium ml-3">Edit</a>
                            <form action="<?php echo e(route('email-campaigns.destroy', $campaign)); ?>" method="POST" class="inline" onsubmit="return confirm('Delete this campaign?')">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('DELETE'); ?>
                                <button type="submit" class="text-red-600 hover:text-red-900 text-sm font-medium ml-3">Delete</button>
                            </form>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td colspan="5" class="px-6 py-8 text-center text-gray-500">
                            No email campaigns found
                        </td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>

    <?php if($campaigns->hasPages()): ?>
        <div class="px-6 py-4 border-t border-gray-200">
            <?php echo e($campaigns->links()); ?>

        </div>
    <?php endif; ?>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\projects\sociallead\laravel-backend\resources\views/email-campaigns/index.blade.php ENDPATH**/ ?>