<nav class="bg-white border-b border-gray-200 px-6 py-4 flex justify-between items-center">
    <div>
        <h2 class="text-xl font-semibold text-gray-800"><?php echo $__env->yieldContent('page-title', 'Dashboard'); ?></h2>
    </div>
    
    <div class="flex items-center space-x-4">
        <div class="relative">
            <input type="text" placeholder="Search..." class="px-4 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
        </div>
        
        <button class="relative p-2 text-gray-600 hover:text-gray-900">
            <i class="fas fa-bell text-xl"></i>
            <span class="absolute top-0 right-0 inline-flex items-center justify-center px-2 py-1 text-xs font-bold leading-none text-white transform translate-x-1/2 -translate-y-1/2 bg-red-600 rounded-full">3</span>
        </button>
        
        <div class="flex items-center space-x-3 border-l border-gray-200 pl-4">
            <img src="https://ui-avatars.com/api/?name=<?php echo e(auth()->user()->name); ?>" alt="Avatar" class="w-8 h-8 rounded-full">
            <div class="text-sm">
                <p class="font-semibold text-gray-800"><?php echo e(auth()->user()->name); ?></p>
                <p class="text-gray-500"><?php echo e(auth()->user()->role); ?></p>
            </div>
            <div class="relative" id="userDropdown">
                <button onclick="document.getElementById('dropdownMenu').classList.toggle('hidden')" class="text-gray-600 hover:text-gray-900 hover:bg-gray-100 px-2 py-1 rounded transition-colors">
                    <i class="fas fa-chevron-down"></i>
                </button>
                <div id="dropdownMenu" class="absolute right-0 mt-2 w-48 bg-white rounded-lg shadow-lg hidden z-10">
                    <a href="<?php echo e(route('profile.edit')); ?>" class="block px-4 py-2 text-gray-700 hover:bg-gray-100">Profile</a>
                    <form method="POST" action="<?php echo e(route('logout')); ?>" class="block">
                        <?php echo csrf_field(); ?>
                        <button type="submit" class="w-full text-left px-4 py-2 text-gray-700 hover:bg-gray-100">Logout</button>
                    </form>
                </div>
            </div>
            <script>
                document.addEventListener('click', function(event) {
                    const dropdown = document.getElementById('userDropdown');
                    if (!dropdown.contains(event.target)) {
                        document.getElementById('dropdownMenu').classList.add('hidden');
                    }
                });
            </script>
        </div>
    </div>
</nav>
<?php /**PATH C:\projects\sociallead\laravel-backend\resources\views/layouts/navbar.blade.php ENDPATH**/ ?>