<?php $__env->startSection('title', 'Integrations'); ?>
<?php $__env->startSection('page-title', 'Integrations'); ?>

<?php $__env->startSection('content'); ?>
<div class="flex justify-between items-center mb-6">
    <h1 class="text-2xl font-bold text-gray-800">Integrations</h1>
    <a href="<?php echo e(route('integrations.create')); ?>" class="px-4 py-2 bg-blue-600 text-white rounded-lg hover:bg-blue-700">
        <i class="fas fa-plus mr-2"></i> New Integration
    </a>
</div>

<?php if(session('success')): ?>
<div class="mb-4 bg-green-50 border border-green-200 rounded-lg p-4">
    <p class="text-green-800"><?php echo e(session('success')); ?></p>
</div>
<?php endif; ?>

<div class="bg-white rounded-lg shadow">
    <div class="p-6 border-b border-gray-200">
        <div class="flex gap-4">
            <input type="text" placeholder="Search integrations..." class="flex-1 px-4 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
            <select class="px-4 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
                <option value="">All Categories</option>
                <option value="CRM">CRM</option>
                <option value="Marketing">Marketing</option>
                <option value="Social">Social Media</option>
                <option value="Analytics">Analytics</option>
                <option value="Communication">Communication</option>
            </select>
        </div>
    </div>

    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6 p-6">
        <?php $__empty_1 = true; $__currentLoopData = $integrations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $integration): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
        <div class="border border-gray-200 rounded-lg p-6 hover:shadow-lg transition-shadow">
            <div class="flex items-start justify-between mb-4">
                <div class="flex items-center gap-3">
                    <?php if($integration->logo): ?>
                    <img src="<?php echo e($integration->logo); ?>" alt="<?php echo e($integration->name); ?>" class="w-12 h-12 rounded">
                    <?php else: ?>
                    <div class="w-12 h-12 bg-blue-100 rounded flex items-center justify-center">
                        <i class="fas fa-plug text-blue-600 text-xl"></i>
                    </div>
                    <?php endif; ?>
                    <div>
                        <h3 class="font-semibold text-gray-900"><?php echo e($integration->name); ?></h3>
                        <p class="text-sm text-gray-500"><?php echo e($integration->provider); ?></p>
                    </div>
                </div>
                <span class="px-2 py-1 text-xs rounded-full 
                    <?php echo e($integration->status === 'AVAILABLE' ? 'bg-green-100 text-green-800' : 
                       ($integration->status === 'COMING_SOON' ? 'bg-yellow-100 text-yellow-800' : 'bg-gray-100 text-gray-800')); ?>">
                    <?php echo e(str_replace('_', ' ', $integration->status)); ?>

                </span>
            </div>

            <p class="text-sm text-gray-600 mb-4 line-clamp-2"><?php echo e($integration->description); ?></p>

            <div class="flex items-center justify-between mb-4">
                <div class="flex items-center gap-1">
                    <i class="fas fa-star text-yellow-400"></i>
                    <span class="text-sm font-medium"><?php echo e(number_format($integration->rating, 1)); ?></span>
                </div>
                <span class="text-sm text-gray-500"><?php echo e(number_format($integration->installs)); ?> installs</span>
            </div>

            <div class="flex items-center justify-between">
                <span class="text-sm font-medium text-blue-600"><?php echo e($integration->pricing); ?></span>
                <div class="flex gap-2">
                    <a href="<?php echo e(route('integrations.show', $integration->id)); ?>" class="text-blue-600 hover:text-blue-900 text-sm">View</a>
                    <a href="<?php echo e(route('integrations.edit', $integration->id)); ?>" class="text-indigo-600 hover:text-indigo-900 text-sm">Edit</a>
                    <form action="<?php echo e(route('integrations.destroy', $integration->id)); ?>" method="POST" class="inline">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('DELETE'); ?>
                        <button type="submit" class="text-red-600 hover:text-red-900 text-sm" onclick="return confirm('Are you sure?')">Delete</button>
                    </form>
                </div>
            </div>
        </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
        <div class="col-span-3 text-center py-8 text-gray-500">
            No integrations found.
        </div>
        <?php endif; ?>
    </div>

    <?php if($integrations->hasPages()): ?>
    <div class="p-6 border-t border-gray-200">
        <?php echo e($integrations->links()); ?>

    </div>
    <?php endif; ?>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\projects\sociallead\laravel-backend\resources\views/integrations/index.blade.php ENDPATH**/ ?>