<?php $__env->startSection('title', 'Calendar'); ?>
<?php $__env->startSection('page-title', 'Calendar Events'); ?>

<?php $__env->startSection('content'); ?>
<div class="bg-white rounded-lg shadow">
    <div class="px-6 py-4 border-b border-gray-200 flex justify-between items-center">
        <h2 class="text-lg font-semibold text-gray-900">Calendar Events</h2>
        <a href="<?php echo e(route('calendar.create')); ?>" class="px-4 py-2 bg-blue-600 text-white rounded-lg hover:bg-blue-700">
            + Create Event
        </a>
    </div>

    <div class="p-6">
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-4">
            <?php $__empty_1 = true; $__currentLoopData = $events; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $event): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <div class="border rounded-lg p-4 hover:shadow-lg transition-shadow" style="border-left: 4px solid <?php echo e($event->color ?? '#3b82f6'); ?>">
                    <h3 class="font-semibold text-gray-900"><?php echo e($event->title); ?></h3>
                    <p class="text-sm text-gray-600 mt-1"><?php echo e($event->description); ?></p>
                    
                    <div class="mt-3 space-y-1 text-sm text-gray-600">
                        <p><i class="fas fa-calendar mr-2"></i><?php echo e(\Carbon\Carbon::parse($event->start_date)->format('M d, Y')); ?></p>
                        <?php if($event->location): ?>
                            <p><i class="fas fa-map-marker-alt mr-2"></i><?php echo e($event->location); ?></p>
                        <?php endif; ?>
                    </div>

                    <div class="mt-4 flex gap-2">
                        <a href="<?php echo e(route('calendar.show', $event->id)); ?>" class="text-blue-600 hover:text-blue-900 text-sm font-medium">View</a>
                        <a href="<?php echo e(route('calendar.edit', $event->id)); ?>" class="text-blue-600 hover:text-blue-900 text-sm font-medium">Edit</a>
                        <form action="<?php echo e(route('calendar.destroy', $event->id)); ?>" method="POST" class="inline" onsubmit="return confirm('Delete this event?')">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('DELETE'); ?>
                            <button type="submit" class="text-red-600 hover:text-red-900 text-sm font-medium">Delete</button>
                        </form>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <div class="col-span-full text-center py-8 text-gray-500">
                    No events found
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\projects\sociallead\laravel-backend\resources\views/calendar/index.blade.php ENDPATH**/ ?>