<?php $__env->startSection('title', 'Reviews'); ?>
<?php $__env->startSection('page-title', 'Customer Reviews'); ?>

<?php $__env->startSection('content'); ?>
<div class="bg-white rounded-lg shadow">
    <div class="px-6 py-4 border-b border-gray-200 flex justify-between items-center">
        <h2 class="text-lg font-semibold text-gray-900">Customer Reviews</h2>
        <a href="<?php echo e(route('reviews.create')); ?>" class="px-4 py-2 bg-blue-600 text-white rounded-lg hover:bg-blue-700">
            + Add Review
        </a>
    </div>

    <div class="overflow-x-auto">
        <table class="w-full">
            <thead class="bg-gray-50 border-b border-gray-200">
                <tr>
                    <th class="px-6 py-3 text-left text-sm font-semibold text-gray-900">Customer</th>
                    <th class="px-6 py-3 text-left text-sm font-semibold text-gray-900">Rating</th>
                    <th class="px-6 py-3 text-left text-sm font-semibold text-gray-900">Comment</th>
                    <th class="px-6 py-3 text-left text-sm font-semibold text-gray-900">Source</th>
                    <th class="px-6 py-3 text-center text-sm font-semibold text-gray-900">Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php $__empty_1 = true; $__currentLoopData = $reviews; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $review): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr class="border-b border-gray-200 hover:bg-gray-50">
                        <td class="px-6 py-4 text-sm text-gray-900"><?php echo e($review->customer_name); ?></td>
                        <td class="px-6 py-4 text-sm">
                            <div class="flex items-center">
                                <?php for($i = 1; $i <= 5; $i++): ?>
                                    <i class="fas fa-star <?php echo e($i <= $review->rating ? 'text-yellow-400' : 'text-gray-300'); ?>"></i>
                                <?php endfor; ?>
                                <span class="ml-2 text-gray-600"><?php echo e($review->rating); ?>/5</span>
                            </div>
                        </td>
                        <td class="px-6 py-4 text-sm text-gray-600"><?php echo e(Str::limit($review->comment, 50)); ?></td>
                        <td class="px-6 py-4 text-sm text-gray-600"><?php echo e($review->source ?? '-'); ?></td>
                        <td class="px-6 py-4 text-center">
                            <a href="<?php echo e(route('reviews.show', $review->id)); ?>" class="text-blue-600 hover:text-blue-900 text-sm font-medium">View</a>
                            <a href="<?php echo e(route('reviews.edit', $review->id)); ?>" class="text-blue-600 hover:text-blue-900 text-sm font-medium ml-3">Edit</a>
                            <form action="<?php echo e(route('reviews.destroy', $review->id)); ?>" method="POST" class="inline" onsubmit="return confirm('Delete this review?')">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('DELETE'); ?>
                                <button type="submit" class="text-red-600 hover:text-red-900 text-sm font-medium ml-3">Delete</button>
                            </form>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td colspan="5" class="px-6 py-8 text-center text-gray-500">
                            No reviews found
                        </td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>

    <?php if($reviews->hasPages()): ?>
        <div class="px-6 py-4 border-t border-gray-200">
            <?php echo e($reviews->links()); ?>

        </div>
    <?php endif; ?>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\projects\sociallead\laravel-backend\resources\views/reviews/index.blade.php ENDPATH**/ ?>