<?php $__env->startSection('title', 'Team Chat'); ?>
<?php $__env->startSection('page-title', 'Team Chat'); ?>

<?php $__env->startSection('content'); ?>
<div class="flex h-[calc(100vh-200px)] gap-4">
    <!-- Team Members Sidebar -->
    <div class="w-80 bg-white rounded-lg shadow flex flex-col">
        <div class="p-4 border-b border-gray-200">
            <h2 class="font-semibold text-gray-800 flex items-center gap-2">
                <i class="fas fa-users text-blue-600"></i>
                Team Members (<?php echo e($teamMembers->count() + 1); ?>)
            </h2>
        </div>
        <div class="flex-1 overflow-y-auto p-2">
            <!-- Current User -->
            <div class="p-3 rounded-lg bg-blue-50 mb-2">
                <div class="flex items-center gap-3">
                    <div class="w-10 h-10 bg-gradient-to-br from-blue-500 to-purple-600 rounded-full flex items-center justify-center text-white font-semibold">
                        <?php echo e(strtoupper(substr(auth()->user()->name, 0, 1))); ?>

                    </div>
                    <div class="flex-1">
                        <p class="text-sm font-medium text-gray-900"><?php echo e(auth()->user()->name); ?> (You)</p>
                        <?php if(auth()->user()->occupation): ?>
                        <p class="text-xs text-gray-600"><?php echo e(auth()->user()->occupation); ?></p>
                        <?php endif; ?>
                    </div>
                    <span class="w-3 h-3 bg-green-500 rounded-full"></span>
                </div>
            </div>

            <!-- Team Members -->
            <?php $__currentLoopData = $teamMembers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $member): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="p-3 rounded-lg hover:bg-gray-50 mb-1">
                <div class="flex items-center gap-3">
                    <div class="w-10 h-10 bg-gradient-to-br from-green-500 to-teal-600 rounded-full flex items-center justify-center text-white font-semibold">
                        <?php echo e(strtoupper(substr($member->name, 0, 1))); ?>

                    </div>
                    <div class="flex-1">
                        <p class="text-sm font-medium text-gray-900"><?php echo e($member->name); ?></p>
                        <?php if($member->occupation): ?>
                        <p class="text-xs text-gray-600"><?php echo e($member->occupation); ?></p>
                        <?php endif; ?>
                    </div>
                    <span class="w-3 h-3 bg-green-500 rounded-full"></span>
                </div>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>

    <!-- Chat Area -->
    <div class="flex-1 bg-white rounded-lg shadow flex flex-col">
        <!-- Chat Header -->
        <div class="p-4 border-b border-gray-200 bg-gradient-to-r from-blue-50 to-purple-50">
            <h2 class="font-semibold text-gray-800 flex items-center gap-2">
                <i class="fas fa-comments text-blue-600"></i>
                Team Chat
            </h2>
            <p class="text-sm text-gray-600 mt-1">Everyone in <?php echo e(auth()->user()->company->name); ?> can see messages here</p>
        </div>

        <!-- Messages -->
        <div class="flex-1 overflow-y-auto p-4 space-y-4" id="messages-container">
            <?php $__empty_1 = true; $__currentLoopData = $teamMessages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $msg): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
            <div class="flex <?php echo e($msg->user_id === auth()->id() ? 'justify-end' : 'justify-start'); ?>" data-message-id="<?php echo e($msg->id); ?>">
                <div class="flex gap-3 max-w-[70%] <?php echo e($msg->user_id === auth()->id() ? 'flex-row-reverse' : ''); ?>">
                    <div class="w-8 h-8 bg-gradient-to-br from-blue-500 to-purple-600 rounded-full flex items-center justify-center text-white text-xs font-semibold flex-shrink-0">
                        <?php echo e(strtoupper(substr($msg->user->name, 0, 1))); ?>

                    </div>
                    <div>
                        <div class="flex items-center gap-2 mb-1 <?php echo e($msg->user_id === auth()->id() ? 'flex-row-reverse' : ''); ?>">
                            <span class="text-xs font-medium text-gray-900"><?php echo e($msg->user->name); ?></span>
                            <span class="text-xs text-gray-500"><?php echo e($msg->created_at->diffForHumans()); ?></span>
                        </div>
                        <?php if($msg->type === 'voice'): ?>
                        <div class="px-4 py-2 rounded-lg <?php echo e($msg->user_id === auth()->id() ? 'bg-blue-600' : 'bg-gray-100'); ?>">
                            <audio controls class="max-w-full">
                                <source src="<?php echo e($msg->file_url); ?>" type="audio/webm">
                                Your browser does not support audio playback.
                            </audio>
                        </div>
                        <?php else: ?>
                        <div class="px-4 py-2 rounded-lg <?php echo e($msg->user_id === auth()->id() ? 'bg-blue-600 text-white' : 'bg-gray-100 text-gray-900'); ?>">
                            <p class="text-sm whitespace-pre-wrap"><?php echo e($msg->content); ?></p>
                        </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <div class="flex items-center justify-center h-full" id="empty-state">
                <div class="text-center">
                    <i class="fas fa-comments text-gray-300 text-6xl mb-4"></i>
                    <p class="text-gray-500 font-medium">No messages yet</p>
                    <p class="text-sm text-gray-400 mt-1">Start the conversation with your team!</p>
                </div>
            </div>
            <?php endif; ?>
            
            <!-- Typing Indicator -->
            <div id="typing-indicator" class="hidden flex justify-start">
                <div class="flex gap-3 max-w-[70%]">
                    <div class="w-8 h-8 bg-gradient-to-br from-gray-400 to-gray-500 rounded-full flex items-center justify-center text-white text-xs font-semibold flex-shrink-0">
                        <i class="fas fa-ellipsis-h"></i>
                    </div>
                    <div>
                        <div class="px-4 py-2 rounded-lg bg-gray-100">
                            <div class="flex gap-1">
                                <span class="w-2 h-2 bg-gray-400 rounded-full animate-bounce" style="animation-delay: 0ms"></span>
                                <span class="w-2 h-2 bg-gray-400 rounded-full animate-bounce" style="animation-delay: 150ms"></span>
                                <span class="w-2 h-2 bg-gray-400 rounded-full animate-bounce" style="animation-delay: 300ms"></span>
                            </div>
                        </div>
                        <p class="text-xs text-gray-500 mt-1" id="typing-user-name"></p>
                    </div>
                </div>
            </div>
        </div>

        <!-- Message Input -->
        <div class="p-4 border-t border-gray-200">
            <form id="message-form" class="flex gap-2">
                <?php echo csrf_field(); ?>
                <input type="file" id="voice-input" accept="audio/*" class="hidden">
                <button type="button" id="voice-btn" 
                        class="px-4 py-2 border border-gray-300 rounded-lg hover:bg-gray-50 flex items-center gap-2"
                        title="Record voice note">
                    <i class="fas fa-microphone text-gray-600"></i>
                </button>
                <textarea id="message-input" 
                          placeholder="Type your message... (Press Enter to send, Shift+Enter for new line)"
                          rows="1"
                          class="flex-1 px-4 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500 resize-none"
                          style="min-height: 42px; max-height: 120px;"></textarea>
                <button type="submit" 
                        class="px-6 py-2 bg-blue-600 text-white rounded-lg hover:bg-blue-700 flex items-center gap-2">
                    <i class="fas fa-paper-plane"></i>
                    Send
                </button>
            </form>
        </div>
    </div>
</div>

<script>
const messagesContainer = document.getElementById('messages-container');
const messageForm = document.getElementById('message-form');
const messageInput = document.getElementById('message-input');
const voiceBtn = document.getElementById('voice-btn');
const typingIndicator = document.getElementById('typing-indicator');
const typingUserName = document.getElementById('typing-user-name');

let isRecording = false;
let mediaRecorder = null;
let audioChunks = [];
let typingTimeout = null;
let lastMessageCount = <?php echo e($teamMessages->count()); ?>;

// Auto-resize textarea
messageInput.addEventListener('input', function() {
    this.style.height = 'auto';
    this.style.height = Math.min(this.scrollHeight, 120) + 'px';
    
    // Send typing indicator
    sendTypingStatus(true);
    
    // Clear previous timeout
    if (typingTimeout) clearTimeout(typingTimeout);
    
    // Stop typing after 3 seconds of inactivity
    typingTimeout = setTimeout(() => {
        sendTypingStatus(false);
    }, 3000);
});

// Handle Enter key
messageInput.addEventListener('keydown', function(e) {
    if (e.key === 'Enter' && !e.shiftKey) {
        e.preventDefault();
        messageForm.dispatchEvent(new Event('submit'));
    }
});

// Scroll to bottom
function scrollToBottom() {
    messagesContainer.scrollTop = messagesContainer.scrollHeight;
}

// Initial scroll
scrollToBottom();

// Send message
messageForm.addEventListener('submit', async function(e) {
    e.preventDefault();
    
    const message = messageInput.value.trim();
    if (!message) return;
    
    // Stop typing indicator
    sendTypingStatus(false);
    
    try {
        const response = await fetch('<?php echo e(route("conversations.send-team-message")); ?>', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>'
            },
            body: JSON.stringify({ message })
        });
        
        const data = await response.json();
        
        if (data.success) {
            // Add message to UI
            addMessageToUI(data.message);
            messageInput.value = '';
            messageInput.style.height = 'auto';
            lastMessageCount++;
            scrollToBottom();
        }
    } catch (error) {
        console.error('Error sending message:', error);
        alert('Failed to send message. Please try again.');
    }
});

// Voice recording
voiceBtn.addEventListener('click', async function() {
    if (!isRecording) {
        // Start recording
        try {
            const stream = await navigator.mediaDevices.getUserMedia({ audio: true });
            mediaRecorder = new MediaRecorder(stream);
            audioChunks = [];
            
            mediaRecorder.ondataavailable = (event) => {
                audioChunks.push(event.data);
            };
            
            mediaRecorder.onstop = async () => {
                const audioBlob = new Blob(audioChunks, { type: 'audio/webm' });
                await sendVoiceNote(audioBlob);
                
                // Stop all tracks
                stream.getTracks().forEach(track => track.stop());
            };
            
            mediaRecorder.start();
            isRecording = true;
            voiceBtn.innerHTML = '<i class="fas fa-stop text-red-600"></i>';
            voiceBtn.classList.add('bg-red-50', 'border-red-300');
        } catch (error) {
            console.error('Error accessing microphone:', error);
            alert('Could not access microphone. Please check permissions.');
        }
    } else {
        // Stop recording
        mediaRecorder.stop();
        isRecording = false;
        voiceBtn.innerHTML = '<i class="fas fa-microphone text-gray-600"></i>';
        voiceBtn.classList.remove('bg-red-50', 'border-red-300');
    }
});

// Send voice note
async function sendVoiceNote(audioBlob) {
    try {
        const formData = new FormData();
        formData.append('voice', audioBlob, 'voice-note.webm');
        
        const response = await fetch('<?php echo e(route("conversations.send-voice-note")); ?>', {
            method: 'POST',
            headers: {
                'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>'
            },
            body: formData
        });
        
        const data = await response.json();
        
        if (data.success) {
            addMessageToUI(data.message);
            lastMessageCount++;
            scrollToBottom();
        }
    } catch (error) {
        console.error('Error sending voice note:', error);
        alert('Failed to send voice note. Please try again.');
    }
}

// Send typing status
async function sendTypingStatus(isTyping) {
    try {
        await fetch('<?php echo e(route("conversations.update-typing")); ?>', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>'
            },
            body: JSON.stringify({ is_typing: isTyping })
        });
    } catch (error) {
        console.error('Error updating typing status:', error);
    }
}

// Add message to UI
function addMessageToUI(msg) {
    // Remove empty state if exists
    const emptyState = document.getElementById('empty-state');
    if (emptyState) emptyState.remove();
    
    const isCurrentUser = msg.user_id === <?php echo e(auth()->id()); ?>;
    const messageDiv = document.createElement('div');
    messageDiv.className = `flex ${isCurrentUser ? 'justify-end' : 'justify-start'}`;
    messageDiv.setAttribute('data-message-id', msg.id);
    
    let messageContent;
    if (msg.type === 'voice') {
        messageContent = `
            <div class="px-4 py-2 rounded-lg ${isCurrentUser ? 'bg-blue-600' : 'bg-gray-100'}">
                <audio controls class="max-w-full">
                    <source src="${msg.file_url}" type="audio/webm">
                    Your browser does not support audio playback.
                </audio>
            </div>
        `;
    } else {
        messageContent = `
            <div class="px-4 py-2 rounded-lg ${isCurrentUser ? 'bg-blue-600 text-white' : 'bg-gray-100 text-gray-900'}">
                <p class="text-sm whitespace-pre-wrap">${escapeHtml(msg.content)}</p>
            </div>
        `;
    }
    
    messageDiv.innerHTML = `
        <div class="flex gap-3 max-w-[70%] ${isCurrentUser ? 'flex-row-reverse' : ''}">
            <div class="w-8 h-8 bg-gradient-to-br from-blue-500 to-purple-600 rounded-full flex items-center justify-center text-white text-xs font-semibold flex-shrink-0">
                ${msg.user.name.charAt(0).toUpperCase()}
            </div>
            <div>
                <div class="flex items-center gap-2 mb-1 ${isCurrentUser ? 'flex-row-reverse' : ''}">
                    <span class="text-xs font-medium text-gray-900">${escapeHtml(msg.user.name)}</span>
                    <span class="text-xs text-gray-500">Just now</span>
                </div>
                ${messageContent}
            </div>
        </div>
    `;
    
    // Insert before typing indicator if it exists
    if (typingIndicator.parentElement) {
        messagesContainer.insertBefore(messageDiv, typingIndicator);
    } else {
        messagesContainer.appendChild(messageDiv);
    }
}

// Escape HTML to prevent XSS
function escapeHtml(text) {
    const div = document.createElement('div');
    div.textContent = text;
    return div.innerHTML;
}

// Check for typing users
async function checkTypingUsers() {
    try {
        const response = await fetch('<?php echo e(route("conversations.get-typing")); ?>');
        const data = await response.json();
        
        if (data.success && data.typing_users.length > 0) {
            const names = data.typing_users.map(u => u.user_name).join(', ');
            typingUserName.textContent = names + (data.typing_users.length === 1 ? ' is typing...' : ' are typing...');
            typingIndicator.classList.remove('hidden');
        } else {
            typingIndicator.classList.add('hidden');
        }
    } catch (error) {
        console.error('Error checking typing users:', error);
    }
}

// Auto-refresh messages every 3 seconds
setInterval(async () => {
    try {
        const response = await fetch('<?php echo e(route("conversations.get-team-messages")); ?>');
        const data = await response.json();
        
        if (data.success && data.messages.length > lastMessageCount) {
            // Add new messages
            const newMessages = data.messages.slice(lastMessageCount);
            newMessages.forEach(msg => {
                // Check if message already exists
                const existingMsg = messagesContainer.querySelector(`[data-message-id="${msg.id}"]`);
                if (!existingMsg) {
                    addMessageToUI(msg);
                }
            });
            lastMessageCount = data.messages.length;
            scrollToBottom();
        }
    } catch (error) {
        console.error('Error fetching messages:', error);
    }
}, 3000);

// Check typing users every 2 seconds
setInterval(checkTypingUsers, 2000);
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\projects\sociallead\laravel-backend\resources\views/conversations/index.blade.php ENDPATH**/ ?>