<?php $__env->startSection('title', 'GetLate Profiles'); ?>
<?php $__env->startSection('page-title', 'GetLate Profiles'); ?>

<?php $__env->startSection('content'); ?>
<div class="flex justify-between items-center mb-6">
    <h1 class="text-2xl font-bold text-gray-800">Social Media Profiles</h1>
    <a href="<?php echo e(route('getlate.profiles.create')); ?>" class="px-4 py-2 bg-blue-600 text-white rounded-lg hover:bg-blue-700">
        <i class="fas fa-plus mr-2"></i> New Profile
    </a>
</div>

<?php if(session('success')): ?>
<div class="mb-4 bg-green-50 border border-green-200 rounded-lg p-4">
    <p class="text-green-800"><?php echo e(session('success')); ?></p>
</div>
<?php endif; ?>

<div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
    <?php $__empty_1 = true; $__currentLoopData = $profiles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $profile): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
    <div class="bg-white rounded-lg shadow p-6">
        <div class="flex items-center justify-between mb-4">
            <h3 class="text-lg font-semibold"><?php echo e($profile->profile_name); ?></h3>
            <span class="px-2 py-1 text-xs rounded-full <?php echo e($profile->is_active ? 'bg-green-100 text-green-800' : 'bg-gray-100 text-gray-800'); ?>">
                <?php echo e($profile->is_active ? 'Active' : 'Inactive'); ?>

            </span>
        </div>

        <?php if($profile->connected_platforms): ?>
        <div class="mb-4">
            <p class="text-sm text-gray-600 mb-2">Connected Platforms:</p>
            <div class="flex flex-wrap gap-2">
                <?php $__currentLoopData = $profile->connected_platforms; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $platform): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <span class="px-2 py-1 bg-blue-100 text-blue-800 text-xs rounded"><?php echo e(ucfirst($platform)); ?></span>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
        <?php endif; ?>

        <div class="flex gap-2">
            <a href="<?php echo e(route('getlate.profiles.show', $profile->id)); ?>" class="flex-1 px-3 py-2 bg-blue-600 text-white text-center rounded hover:bg-blue-700 text-sm">
                View
            </a>
            <form action="<?php echo e(route('getlate.profiles.destroy', $profile->id)); ?>" method="POST" class="flex-1">
                <?php echo csrf_field(); ?>
                <?php echo method_field('DELETE'); ?>
                <button type="submit" class="w-full px-3 py-2 bg-red-600 text-white rounded hover:bg-red-700 text-sm" onclick="return confirm('Are you sure?')">
                    Delete
                </button>
            </form>
        </div>
    </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
    <div class="col-span-3 text-center py-8 text-gray-500">
        No profiles found. Create your first profile to start posting.
    </div>
    <?php endif; ?>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\projects\sociallead\laravel-backend\resources\views/getlate/profiles/index.blade.php ENDPATH**/ ?>